<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ATTRIBUTESTYPE StructType
 * Meta information extracted from the WSDL
 * - documentation: A generic name/value Attributes type
 * @subpackage Structs
 */
class ATTRIBUTESTYPE extends AbstractStructBase
{
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $NAME;
    /**
     * The _
     * @var mixed
     */
    public $_;
    /**
     * Constructor method for ATTRIBUTESTYPE
     * @uses ATTRIBUTESTYPE::setNAME()
     * @uses ATTRIBUTESTYPE::set_()
     * @param string $nAME
     * @param mixed $_
     */
    public function __construct($nAME = null, $_ = null)
    {
        $this
            ->setNAME($nAME)
            ->set_($_);
    }
    /**
     * Get NAME value
     * @return string
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\ATTRIBUTESTYPE
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nAME) && mb_strlen($nAME) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($nAME)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nAME) && mb_strlen($nAME) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get _ value
     * @return mixed|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param mixed $_
     * @return \StructType\ATTRIBUTESTYPE
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ATTRIBUTESTYPE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
