<?php

namespace EnumType;

/**
 * This class stands for USERTYPE EnumType
 * @subpackage Enumerations
 */
class USERTYPE
{
    /**
     * Constant for value 'USER'
     * @return string 'USER'
     */
    const VALUE_USER = 'USER';
    /**
     * Constant for value 'ARCHIVE'
     * @return string 'ARCHIVE'
     */
    const VALUE_ARCHIVE = 'ARCHIVE';
    /**
     * Constant for value 'EARCHIVE'
     * @return string 'EARCHIVE'
     */
    const VALUE_EARCHIVE = 'EARCHIVE';
    /**
     * Constant for value 'EARCHIVE_ARCHIVE'
     * @return string 'EARCHIVE_ARCHIVE'
     */
    const VALUE_EARCHIVE_ARCHIVE = 'EARCHIVE_ARCHIVE';
    /**
     * Constant for value 'EDESPATCH'
     * @return string 'EDESPATCH'
     */
    const VALUE_EDESPATCH = 'EDESPATCH';
    /**
     * Constant for value 'EDESPATCH_ARCHIVE'
     * @return string 'EDESPATCH_ARCHIVE'
     */
    const VALUE_EDESPATCH_ARCHIVE = 'EDESPATCH_ARCHIVE';
    /**
     * Constant for value 'SERBEST_MESLEK'
     * @return string 'SERBEST_MESLEK'
     */
    const VALUE_SERBEST_MESLEK = 'SERBEST_MESLEK';
    /**
     * Constant for value 'MUSTAHSIL'
     * @return string 'MUSTAHSIL'
     */
    const VALUE_MUSTAHSIL = 'MUSTAHSIL';
    /**
     * Constant for value 'CHANGECUSTOMER'
     * @return string 'CHANGECUSTOMER'
     */
    const VALUE_CHANGECUSTOMER = 'CHANGECUSTOMER';
    /**
     * Constant for value 'ZREPORT'
     * @return string 'ZREPORT'
     */
    const VALUE_ZREPORT = 'ZREPORT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER
     * @uses self::VALUE_ARCHIVE
     * @uses self::VALUE_EARCHIVE
     * @uses self::VALUE_EARCHIVE_ARCHIVE
     * @uses self::VALUE_EDESPATCH
     * @uses self::VALUE_EDESPATCH_ARCHIVE
     * @uses self::VALUE_SERBEST_MESLEK
     * @uses self::VALUE_MUSTAHSIL
     * @uses self::VALUE_CHANGECUSTOMER
     * @uses self::VALUE_ZREPORT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER,
            self::VALUE_ARCHIVE,
            self::VALUE_EARCHIVE,
            self::VALUE_EARCHIVE_ARCHIVE,
            self::VALUE_EDESPATCH,
            self::VALUE_EDESPATCH_ARCHIVE,
            self::VALUE_SERBEST_MESLEK,
            self::VALUE_MUSTAHSIL,
            self::VALUE_CHANGECUSTOMER,
            self::VALUE_ZREPORT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
