<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoiceRequest StructType
 * Meta information extracted from the WSDL
 * - type: SendInvoiceRequest
 * @subpackage Structs
 */
class SendInvoiceRequest extends REQUEST
{
    /**
     * The INVOICE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The SENDER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SENDER
     */
    public $SENDER;
    /**
     * The RECEIVER
     * @var \StructType\RECEIVER
     */
    public $RECEIVER;
    /**
     * Constructor method for SendInvoiceRequest
     * @uses SendInvoiceRequest::setINVOICE()
     * @uses SendInvoiceRequest::setSENDER()
     * @uses SendInvoiceRequest::setRECEIVER()
     * @param \StructType\INVOICE[] $iNVOICE
     * @param \StructType\SENDER $sENDER
     * @param \StructType\RECEIVER $rECEIVER
     */
    public function __construct(array $iNVOICE = array(), \StructType\SENDER $sENDER = null, \StructType\RECEIVER $rECEIVER = null)
    {
        $this
            ->setINVOICE($iNVOICE)
            ->setSENDER($sENDER)
            ->setRECEIVER($rECEIVER);
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICEForArrayConstraintsFromSetINVOICE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendInvoiceRequestINVOICEItem) {
            // validation for constraint: itemType
            if (!$sendInvoiceRequestINVOICEItem instanceof \StructType\INVOICE) {
                $invalidValues[] = is_object($sendInvoiceRequestINVOICEItem) ? get_class($sendInvoiceRequestINVOICEItem) : sprintf('%s(%s)', gettype($sendInvoiceRequestINVOICEItem), var_export($sendInvoiceRequestINVOICEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\SendInvoiceRequest
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICEArrayErrorMessage = self::validateINVOICEForArrayConstraintsFromSetINVOICE($iNVOICE))) {
            throw new \InvalidArgumentException($iNVOICEArrayErrorMessage, __LINE__);
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\SendInvoiceRequest
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get SENDER value
     * @return \StructType\SENDER|null
     */
    public function getSENDER()
    {
        return $this->SENDER;
    }
    /**
     * Set SENDER value
     * @param \StructType\SENDER $sENDER
     * @return \StructType\SendInvoiceRequest
     */
    public function setSENDER(\StructType\SENDER $sENDER = null)
    {
        $this->SENDER = $sENDER;
        return $this;
    }
    /**
     * Get RECEIVER value
     * @return \StructType\RECEIVER|null
     */
    public function getRECEIVER()
    {
        return $this->RECEIVER;
    }
    /**
     * Set RECEIVER value
     * @param \StructType\RECEIVER $rECEIVER
     * @return \StructType\SendInvoiceRequest
     */
    public function setRECEIVER(\StructType\RECEIVER $rECEIVER = null)
    {
        $this->RECEIVER = $rECEIVER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
