<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MARK StructType
 * @subpackage Structs
 */
class MARK extends AbstractStructBase
{
    /**
     * The INVOICE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The ENVELOPE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ENVELOPE[]
     */
    public $ENVELOPE;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for MARK
     * @uses MARK::setINVOICE()
     * @uses MARK::setENVELOPE()
     * @uses MARK::setValue()
     * @param \StructType\INVOICE[] $iNVOICE
     * @param \StructType\ENVELOPE[] $eNVELOPE
     * @param string $value
     */
    public function __construct(array $iNVOICE = array(), array $eNVELOPE = array(), $value = null)
    {
        $this
            ->setINVOICE($iNVOICE)
            ->setENVELOPE($eNVELOPE)
            ->setValue($value);
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICEForArrayConstraintsFromSetINVOICE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mARKINVOICEItem) {
            // validation for constraint: itemType
            if (!$mARKINVOICEItem instanceof \StructType\INVOICE) {
                $invalidValues[] = is_object($mARKINVOICEItem) ? get_class($mARKINVOICEItem) : sprintf('%s(%s)', gettype($mARKINVOICEItem), var_export($mARKINVOICEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\MARK
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICEArrayErrorMessage = self::validateINVOICEForArrayConstraintsFromSetINVOICE($iNVOICE))) {
            throw new \InvalidArgumentException($iNVOICEArrayErrorMessage, __LINE__);
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\MARK
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get ENVELOPE value
     * @return \StructType\ENVELOPE[]
     */
    public function getENVELOPE()
    {
        return $this->ENVELOPE;
    }
    /**
     * This method is responsible for validating the values passed to the setENVELOPE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setENVELOPE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateENVELOPEForArrayConstraintsFromSetENVELOPE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mARKENVELOPEItem) {
            // validation for constraint: itemType
            if (!$mARKENVELOPEItem instanceof \StructType\ENVELOPE) {
                $invalidValues[] = is_object($mARKENVELOPEItem) ? get_class($mARKENVELOPEItem) : sprintf('%s(%s)', gettype($mARKENVELOPEItem), var_export($mARKENVELOPEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ENVELOPE property can only contain items of type \StructType\ENVELOPE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ENVELOPE value
     * @throws \InvalidArgumentException
     * @param \StructType\ENVELOPE[] $eNVELOPE
     * @return \StructType\MARK
     */
    public function setENVELOPE(array $eNVELOPE = array())
    {
        // validation for constraint: array
        if ('' !== ($eNVELOPEArrayErrorMessage = self::validateENVELOPEForArrayConstraintsFromSetENVELOPE($eNVELOPE))) {
            throw new \InvalidArgumentException($eNVELOPEArrayErrorMessage, __LINE__);
        }
        $this->ENVELOPE = $eNVELOPE;
        return $this;
    }
    /**
     * Add item to ENVELOPE value
     * @throws \InvalidArgumentException
     * @param \StructType\ENVELOPE $item
     * @return \StructType\MARK
     */
    public function addToENVELOPE(\StructType\ENVELOPE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ENVELOPE) {
            throw new \InvalidArgumentException(sprintf('The ENVELOPE property can only contain items of type \StructType\ENVELOPE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ENVELOPE[] = $item;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\MARK
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MARK
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
