<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICE StructType
 * @subpackage Structs
 */
class INVOICE extends AbstractStructBase
{
    /**
     * The HEADER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HEADER
     */
    public $HEADER;
    /**
     * The CONTENT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Base64Binary
     */
    public $CONTENT;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $UUID;
    /**
     * The LIST_ID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $LIST_ID;
    /**
     * Constructor method for INVOICE
     * @uses INVOICE::setHEADER()
     * @uses INVOICE::setCONTENT()
     * @uses INVOICE::setID()
     * @uses INVOICE::setUUID()
     * @uses INVOICE::setLIST_ID()
     * @param \StructType\HEADER $hEADER
     * @param \StructType\Base64Binary $cONTENT
     * @param string $iD
     * @param string $uUID
     * @param int $lIST_ID
     */
    public function __construct(\StructType\HEADER $hEADER = null, \StructType\Base64Binary $cONTENT = null, $iD = null, $uUID = null, $lIST_ID = null)
    {
        $this
            ->setHEADER($hEADER)
            ->setCONTENT($cONTENT)
            ->setID($iD)
            ->setUUID($uUID)
            ->setLIST_ID($lIST_ID);
    }
    /**
     * Get HEADER value
     * @return \StructType\HEADER|null
     */
    public function getHEADER()
    {
        return $this->HEADER;
    }
    /**
     * Set HEADER value
     * @param \StructType\HEADER $hEADER
     * @return \StructType\INVOICE
     */
    public function setHEADER(\StructType\HEADER $hEADER = null)
    {
        $this->HEADER = $hEADER;
        return $this;
    }
    /**
     * Get CONTENT value
     * @return \StructType\Base64Binary|null
     */
    public function getCONTENT()
    {
        return $this->CONTENT;
    }
    /**
     * Set CONTENT value
     * @param \StructType\Base64Binary $cONTENT
     * @return \StructType\INVOICE
     */
    public function setCONTENT(\StructType\Base64Binary $cONTENT = null)
    {
        $this->CONTENT = $cONTENT;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\INVOICE
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\INVOICE
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get LIST_ID value
     * @return int|null
     */
    public function getLIST_ID()
    {
        return $this->LIST_ID;
    }
    /**
     * Set LIST_ID value
     * @param int $lIST_ID
     * @return \StructType\INVOICE
     */
    public function setLIST_ID($lIST_ID = null)
    {
        // validation for constraint: int
        if (!is_null($lIST_ID) && !(is_int($lIST_ID) || ctype_digit($lIST_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lIST_ID, true), gettype($lIST_ID)), __LINE__);
        }
        $this->LIST_ID = $lIST_ID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\INVOICE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
