<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceRequest $request
     * @return \StructType\SendInvoiceResponse|bool
     */
    public function SendInvoice(\StructType\SendInvoiceRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoice($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceResponseRequest $request
     * @return \StructType\SendInvoiceResponseResponse|bool
     */
    public function SendInvoiceResponse(\StructType\SendInvoiceResponseRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoiceResponse($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceResponseWithServerSign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceResponseWithServerSignRequest $request
     * @return \StructType\SendInvoiceResponseWithServerSignResponse|bool
     */
    public function SendInvoiceResponseWithServerSign(\StructType\SendInvoiceResponseWithServerSignRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoiceResponseWithServerSign($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendInvoiceResponse|\StructType\SendInvoiceResponseResponse|\StructType\SendInvoiceResponseWithServerSignResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
