<?php

namespace EnumType;

/**
 * This class stands for USERCONTENTTYPE EnumType
 * @subpackage Enumerations
 */
class USERCONTENTTYPE
{
    /**
     * Constant for value 'PROCESSUSER'
     * @return string 'PROCESSUSER'
     */
    const VALUE_PROCESSUSER = 'PROCESSUSER';
    /**
     * Constant for value 'CANCELUSER'
     * @return string 'CANCELUSER'
     */
    const VALUE_CANCELUSER = 'CANCELUSER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PROCESSUSER
     * @uses self::VALUE_CANCELUSER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PROCESSUSER,
            self::VALUE_CANCELUSER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
