<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uetdsEsyaParamTasimaTuruSonuc StructType
 * @subpackage Structs
 */
class UetdsEsyaParamTasimaTuruSonuc extends AbstractStructBase
{
    /**
     * The sonucKodu
     * @var int
     */
    public $sonucKodu;
    /**
     * The sonucMesaji
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sonucMesaji;
    /**
     * The tasimaTuruListesi
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParamTasimaTuruListesi[]
     */
    public $tasimaTuruListesi;
    /**
     * Constructor method for uetdsEsyaParamTasimaTuruSonuc
     * @uses UetdsEsyaParamTasimaTuruSonuc::setSonucKodu()
     * @uses UetdsEsyaParamTasimaTuruSonuc::setSonucMesaji()
     * @uses UetdsEsyaParamTasimaTuruSonuc::setTasimaTuruListesi()
     * @param int $sonucKodu
     * @param string $sonucMesaji
     * @param \StructType\ParamTasimaTuruListesi[] $tasimaTuruListesi
     */
    public function __construct($sonucKodu = null, $sonucMesaji = null, array $tasimaTuruListesi = array())
    {
        $this
            ->setSonucKodu($sonucKodu)
            ->setSonucMesaji($sonucMesaji)
            ->setTasimaTuruListesi($tasimaTuruListesi);
    }
    /**
     * Get sonucKodu value
     * @return int|null
     */
    public function getSonucKodu()
    {
        return $this->sonucKodu;
    }
    /**
     * Set sonucKodu value
     * @param int $sonucKodu
     * @return \StructType\UetdsEsyaParamTasimaTuruSonuc
     */
    public function setSonucKodu($sonucKodu = null)
    {
        // validation for constraint: int
        if (!is_null($sonucKodu) && !(is_int($sonucKodu) || ctype_digit($sonucKodu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonucKodu, true), gettype($sonucKodu)), __LINE__);
        }
        $this->sonucKodu = $sonucKodu;
        return $this;
    }
    /**
     * Get sonucMesaji value
     * @return string|null
     */
    public function getSonucMesaji()
    {
        return $this->sonucMesaji;
    }
    /**
     * Set sonucMesaji value
     * @param string $sonucMesaji
     * @return \StructType\UetdsEsyaParamTasimaTuruSonuc
     */
    public function setSonucMesaji($sonucMesaji = null)
    {
        // validation for constraint: string
        if (!is_null($sonucMesaji) && !is_string($sonucMesaji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonucMesaji, true), gettype($sonucMesaji)), __LINE__);
        }
        $this->sonucMesaji = $sonucMesaji;
        return $this;
    }
    /**
     * Get tasimaTuruListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParamTasimaTuruListesi[]|null
     */
    public function getTasimaTuruListesi()
    {
        return isset($this->tasimaTuruListesi) ? $this->tasimaTuruListesi : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTasimaTuruListesi method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTasimaTuruListesi method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTasimaTuruListesiForArrayConstraintsFromSetTasimaTuruListesi(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uetdsEsyaParamTasimaTuruSonucTasimaTuruListesiItem) {
            // validation for constraint: itemType
            if (!$uetdsEsyaParamTasimaTuruSonucTasimaTuruListesiItem instanceof \StructType\ParamTasimaTuruListesi) {
                $invalidValues[] = is_object($uetdsEsyaParamTasimaTuruSonucTasimaTuruListesiItem) ? get_class($uetdsEsyaParamTasimaTuruSonucTasimaTuruListesiItem) : sprintf('%s(%s)', gettype($uetdsEsyaParamTasimaTuruSonucTasimaTuruListesiItem), var_export($uetdsEsyaParamTasimaTuruSonucTasimaTuruListesiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tasimaTuruListesi property can only contain items of type \StructType\ParamTasimaTuruListesi, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tasimaTuruListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParamTasimaTuruListesi[] $tasimaTuruListesi
     * @return \StructType\UetdsEsyaParamTasimaTuruSonuc
     */
    public function setTasimaTuruListesi(array $tasimaTuruListesi = array())
    {
        // validation for constraint: array
        if ('' !== ($tasimaTuruListesiArrayErrorMessage = self::validateTasimaTuruListesiForArrayConstraintsFromSetTasimaTuruListesi($tasimaTuruListesi))) {
            throw new \InvalidArgumentException($tasimaTuruListesiArrayErrorMessage, __LINE__);
        }
        if (is_null($tasimaTuruListesi) || (is_array($tasimaTuruListesi) && empty($tasimaTuruListesi))) {
            unset($this->tasimaTuruListesi);
        } else {
            $this->tasimaTuruListesi = $tasimaTuruListesi;
        }
        return $this;
    }
    /**
     * Add item to tasimaTuruListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\ParamTasimaTuruListesi $item
     * @return \StructType\UetdsEsyaParamTasimaTuruSonuc
     */
    public function addToTasimaTuruListesi(\StructType\ParamTasimaTuruListesi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParamTasimaTuruListesi) {
            throw new \InvalidArgumentException(sprintf('The tasimaTuruListesi property can only contain items of type \StructType\ParamTasimaTuruListesi, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tasimaTuruListesi[] = $item;
        return $this;
    }
}
