<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Yeni ServiceType
 * @subpackage Services
 */
class Yeni extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named yeniSeferEkleV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YeniSeferEkleV3 $parameters
     * @return \StructType\YeniSeferEkleV3Response|bool
     */
    public function yeniSeferEkleV3(\StructType\YeniSeferEkleV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yeniSeferEkleV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\YeniSeferEkleV3Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
