<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Firma ServiceType
 * @subpackage Services
 */
class Firma extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named firmaUyarmaSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FirmaUyarmaSorgula $parameters
     * @return \StructType\FirmaUyarmaSorgulaResponse|bool
     */
    public function firmaUyarmaSorgula(\StructType\FirmaUyarmaSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->firmaUyarmaSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named firmaCezaSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FirmaCezaSorgula $parameters
     * @return \StructType\FirmaCezaSorgulaResponse|bool
     */
    public function firmaCezaSorgula(\StructType\FirmaCezaSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->firmaCezaSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FirmaCezaSorgulaResponse|\StructType\FirmaUyarmaSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
