<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Web ServiceType
 * @subpackage Services
 */
class Web extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named webServisVersiyon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebServisVersiyon $parameters
     * @return \StructType\WebServisVersiyonResponse|bool
     */
    public function webServisVersiyon(\StructType\WebServisVersiyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->webServisVersiyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WebServisVersiyonResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
