<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servis.turkiye.gov.tr/services/g2g/kdgm/test/uetdsesya?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servis.turkiye.gov.tr/services/g2g/kdgm/test/uetdsesya?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Iptal ServiceType
 */
$iptal = new \ServiceType\Iptal($options);
/**
 * Sample call for iptalTurleri operation/method
 */
if ($iptal->iptalTurleri(new \StructType\IptalTurleri()) !== false) {
    print_r($iptal->getResult());
} else {
    print_r($iptal->getLastError());
}
/**
 * Samples for Param ServiceType
 */
$param = new \ServiceType\Param($options);
/**
 * Sample call for paramTehlikeliMaddeTasimaSekli operation/method
 */
if ($param->paramTehlikeliMaddeTasimaSekli(new \StructType\ParamTehlikeliMaddeTasimaSekli()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramYukBirimi operation/method
 */
if ($param->paramYukBirimi(new \StructType\ParamYukBirimi()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramTasimaTurleri operation/method
 */
if ($param->paramTasimaTurleri(new \StructType\ParamTasimaTurleri()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramTehlikeMaddeMuafiyetTurleri operation/method
 */
if ($param->paramTehlikeMaddeMuafiyetTurleri(new \StructType\ParamTehlikeMaddeMuafiyetTurleri()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramYukTuru operation/method
 */
if ($param->paramYukTuru(new \StructType\ParamYukTuru()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Samples for Sefer ServiceType
 */
$sefer = new \ServiceType\Sefer($options);
/**
 * Sample call for seferIptalTurleri operation/method
 */
if ($sefer->seferIptalTurleri(new \StructType\SeferIptalTurleri()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferRaporuV3 operation/method
 */
if ($sefer->seferRaporuV3(new \StructType\SeferRaporuV3()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferDetayiV3 operation/method
 */
if ($sefer->seferDetayiV3(new \StructType\SeferDetayiV3()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferDuzenleV3 operation/method
 */
if ($sefer->seferDuzenleV3(new \StructType\SeferDuzenleV3()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferIptalEtV3 operation/method
 */
if ($sefer->seferIptalEtV3(new \StructType\SeferIptalEtV3()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferAktifEtV3 operation/method
 */
if ($sefer->seferAktifEtV3(new \StructType\SeferAktifEtV3()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferListesiV3 operation/method
 */
if ($sefer->seferListesiV3(new \StructType\SeferListesiV3()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Samples for Mesleki ServiceType
 */
$mesleki = new \ServiceType\Mesleki($options);
/**
 * Sample call for meslekiYeterlilikSorgula operation/method
 */
if ($mesleki->meslekiYeterlilikSorgula(new \StructType\MeslekiYeterlilikSorgula()) !== false) {
    print_r($mesleki->getResult());
} else {
    print_r($mesleki->getLastError());
}
/**
 * Samples for Arac ServiceType
 */
$arac = new \ServiceType\Arac($options);
/**
 * Sample call for aracMuayeneSorgula operation/method
 */
if ($arac->aracMuayeneSorgula(new \StructType\AracMuayeneSorgula()) !== false) {
    print_r($arac->getResult());
} else {
    print_r($arac->getLastError());
}
/**
 * Samples for Ip ServiceType
 */
$ip = new \ServiceType\Ip($options);
/**
 * Sample call for ipTanimla operation/method
 */
if ($ip->ipTanimla(new \StructType\IpTanimla()) !== false) {
    print_r($ip->getResult());
} else {
    print_r($ip->getLastError());
}
/**
 * Sample call for ipListele operation/method
 */
if ($ip->ipListele(new \StructType\IpListele()) !== false) {
    print_r($ip->getResult());
} else {
    print_r($ip->getLastError());
}
/**
 * Sample call for ipSil operation/method
 */
if ($ip->ipSil(new \StructType\IpSil()) !== false) {
    print_r($ip->getResult());
} else {
    print_r($ip->getLastError());
}
/**
 * Samples for Vize ServiceType
 */
$vize = new \ServiceType\Vize($options);
/**
 * Sample call for vizeOnBasvuru operation/method
 */
if ($vize->vizeOnBasvuru(new \StructType\VizeOnBasvuru()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruSurucuEkle operation/method
 */
if ($vize->vizeOnBasvuruSurucuEkle(new \StructType\VizeOnBasvuruSurucuEkle()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruIptal operation/method
 */
if ($vize->vizeOnBasvuruIptal(new \StructType\VizeOnBasvuruIptal()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruListele operation/method
 */
if ($vize->vizeOnBasvuruListele(new \StructType\VizeOnBasvuruListele()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruDetay operation/method
 */
if ($vize->vizeOnBasvuruDetay(new \StructType\VizeOnBasvuruDetay()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Samples for Yeni ServiceType
 */
$yeni = new \ServiceType\Yeni($options);
/**
 * Sample call for yeniSeferEkleV3 operation/method
 */
if ($yeni->yeniSeferEkleV3(new \StructType\YeniSeferEkleV3()) !== false) {
    print_r($yeni->getResult());
} else {
    print_r($yeni->getLastError());
}
/**
 * Samples for Sefere ServiceType
 */
$sefere = new \ServiceType\Sefere($options);
/**
 * Sample call for sefereYukEkleV3 operation/method
 */
if ($sefere->sefereYukEkleV3(new \StructType\SefereYukEkleV3()) !== false) {
    print_r($sefere->getResult());
} else {
    print_r($sefere->getLastError());
}
/**
 * Samples for Yuk ServiceType
 */
$yuk = new \ServiceType\Yuk($options);
/**
 * Sample call for yukDuzenleV3 operation/method
 */
if ($yuk->yukDuzenleV3(new \StructType\YukDuzenleV3()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukIptalEtV3 operation/method
 */
if ($yuk->yukIptalEtV3(new \StructType\YukIptalEtV3()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukAktifEtV3 operation/method
 */
if ($yuk->yukAktifEtV3(new \StructType\YukAktifEtV3()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukDetayiV3 operation/method
 */
if ($yuk->yukDetayiV3(new \StructType\YukDetayiV3()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Samples for Servis ServiceType
 */
$servis = new \ServiceType\Servis($options);
/**
 * Sample call for servisTest operation/method
 */
if ($servis->servisTest(new \StructType\ServisTest()) !== false) {
    print_r($servis->getResult());
} else {
    print_r($servis->getLastError());
}
/**
 * Samples for Yetki ServiceType
 */
$yetki = new \ServiceType\Yetki($options);
/**
 * Sample call for yetkiBelgesiKontrol operation/method
 */
if ($yetki->yetkiBelgesiKontrol(new \StructType\YetkiBelgesiKontrol()) !== false) {
    print_r($yetki->getResult());
} else {
    print_r($yetki->getLastError());
}
