<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sefer ServiceType
 * @subpackage Services
 */
class Sefer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named seferIptalTurleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferIptalTurleri $parameters
     * @return \StructType\SeferIptalTurleriResponse|bool
     */
    public function seferIptalTurleri(\StructType\SeferIptalTurleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferIptalTurleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferRaporuV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferRaporuV3 $parameters
     * @return \StructType\SeferRaporuV3Response|bool
     */
    public function seferRaporuV3(\StructType\SeferRaporuV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferRaporuV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferDetayiV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferDetayiV3 $parameters
     * @return \StructType\SeferDetayiV3Response|bool
     */
    public function seferDetayiV3(\StructType\SeferDetayiV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferDetayiV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferDuzenleV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferDuzenleV3 $parameters
     * @return \StructType\SeferDuzenleV3Response|bool
     */
    public function seferDuzenleV3(\StructType\SeferDuzenleV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferDuzenleV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferIptalEtV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferIptalEtV3 $parameters
     * @return \StructType\SeferIptalEtV3Response|bool
     */
    public function seferIptalEtV3(\StructType\SeferIptalEtV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferIptalEtV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferAktifEtV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferAktifEtV3 $parameters
     * @return \StructType\SeferAktifEtV3Response|bool
     */
    public function seferAktifEtV3(\StructType\SeferAktifEtV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferAktifEtV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferListesiV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferListesiV3 $parameters
     * @return \StructType\SeferListesiV3Response|bool
     */
    public function seferListesiV3(\StructType\SeferListesiV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferListesiV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SeferAktifEtV3Response|\StructType\SeferDetayiV3Response|\StructType\SeferDuzenleV3Response|\StructType\SeferIptalEtV3Response|\StructType\SeferIptalTurleriResponse|\StructType\SeferListesiV3Response|\StructType\SeferRaporuV3Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
