<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Iptal ServiceType
 * @subpackage Services
 */
class Iptal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named iptalTurleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IptalTurleri $parameters
     * @return \StructType\IptalTurleriResponse|bool
     */
    public function iptalTurleri(\StructType\IptalTurleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->iptalTurleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IptalTurleriResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
