<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Yuk ServiceType
 * @subpackage Services
 */
class Yuk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named yukDuzenleV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukDuzenleV3 $parameters
     * @return \StructType\YukDuzenleV3Response|bool
     */
    public function yukDuzenleV3(\StructType\YukDuzenleV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukDuzenleV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named yukIptalEtV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukIptalEtV3 $parameters
     * @return \StructType\YukIptalEtV3Response|bool
     */
    public function yukIptalEtV3(\StructType\YukIptalEtV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukIptalEtV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named yukAktifEtV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukAktifEtV3 $parameters
     * @return \StructType\YukAktifEtV3Response|bool
     */
    public function yukAktifEtV3(\StructType\YukAktifEtV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukAktifEtV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named yukDetayiV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukDetayiV3 $parameters
     * @return \StructType\YukDetayiV3Response|bool
     */
    public function yukDetayiV3(\StructType\YukDetayiV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukDetayiV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\YukAktifEtV3Response|\StructType\YukDetayiV3Response|\StructType\YukDuzenleV3Response|\StructType\YukIptalEtV3Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
