<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sefere ServiceType
 * @subpackage Services
 */
class Sefere extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sefereYukEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SefereYukEkle $parameters
     * @return \StructType\SefereYukEkleResponse|bool
     */
    public function sefereYukEkle(\StructType\SefereYukEkle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sefereYukEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SefereYukEkleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
