<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servis.turkiye.gov.tr/services/g2g/kdgm/test/uetdsesya?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servis.turkiye.gov.tr/services/g2g/kdgm/test/uetdsesya?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Iptal ServiceType
 */
$iptal = new \ServiceType\Iptal($options);
/**
 * Sample call for iptalTurleri operation/method
 */
if ($iptal->iptalTurleri(new \StructType\IptalTurleri()) !== false) {
    print_r($iptal->getResult());
} else {
    print_r($iptal->getLastError());
}
/**
 * Samples for Yuk ServiceType
 */
$yuk = new \ServiceType\Yuk($options);
/**
 * Sample call for yukBildirimiListesi operation/method
 */
if ($yuk->yukBildirimiListesi(new \StructType\YukBildirimiListesi()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiGuncelle operation/method
 */
if ($yuk->yukBildirimiGuncelle(new \StructType\YukBildirimiGuncelle()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiGuncelleV2 operation/method
 */
if ($yuk->yukBildirimiGuncelleV2(new \StructType\YukBildirimiGuncelleV2()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiIptalEt operation/method
 */
if ($yuk->yukBildirimiIptalEt(new \StructType\YukBildirimiIptalEt()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukIptalEtV2 operation/method
 */
if ($yuk->yukIptalEtV2(new \StructType\YukIptalEtV2()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiDetayi operation/method
 */
if ($yuk->yukBildirimiDetayi(new \StructType\YukBildirimiDetayi()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiDetayiV2 operation/method
 */
if ($yuk->yukBildirimiDetayiV2(new \StructType\YukBildirimiDetayiV2()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimRaporu operation/method
 */
if ($yuk->yukBildirimRaporu(new \StructType\YukBildirimRaporu()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Samples for Yeni ServiceType
 */
$yeni = new \ServiceType\Yeni($options);
/**
 * Sample call for yeniYukKaydiBildirV2 operation/method
 */
if ($yeni->yeniYukKaydiBildirV2(new \StructType\YeniYukKaydiBildirV2()) !== false) {
    print_r($yeni->getResult());
} else {
    print_r($yeni->getLastError());
}
/**
 * Sample call for yeniYukKaydiBildir operation/method
 */
if ($yeni->yeniYukKaydiBildir(new \StructType\YeniYukKaydiBildir()) !== false) {
    print_r($yeni->getResult());
} else {
    print_r($yeni->getLastError());
}
/**
 * Samples for Sefer ServiceType
 */
$sefer = new \ServiceType\Sefer($options);
/**
 * Sample call for seferGuncelle operation/method
 */
if ($sefer->seferGuncelle(new \StructType\SeferGuncelle()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferIptalEt operation/method
 */
if ($sefer->seferIptalEt(new \StructType\SeferIptalEt()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferAktifEt operation/method
 */
if ($sefer->seferAktifEt(new \StructType\SeferAktifEt()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferBildirimRaporu operation/method
 */
if ($sefer->seferBildirimRaporu(new \StructType\SeferBildirimRaporu()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Sample call for seferBildirimOzeti operation/method
 */
if ($sefer->seferBildirimOzeti(new \StructType\SeferBildirimOzeti()) !== false) {
    print_r($sefer->getResult());
} else {
    print_r($sefer->getLastError());
}
/**
 * Samples for Sefere ServiceType
 */
$sefere = new \ServiceType\Sefere($options);
/**
 * Sample call for sefereYukEkle operation/method
 */
if ($sefere->sefereYukEkle(new \StructType\SefereYukEkle()) !== false) {
    print_r($sefere->getResult());
} else {
    print_r($sefere->getLastError());
}
/**
 * Samples for Mesleki ServiceType
 */
$mesleki = new \ServiceType\Mesleki($options);
/**
 * Sample call for meslekiYeterlilikSorgula operation/method
 */
if ($mesleki->meslekiYeterlilikSorgula(new \StructType\MeslekiYeterlilikSorgula()) !== false) {
    print_r($mesleki->getResult());
} else {
    print_r($mesleki->getLastError());
}
/**
 * Samples for Arac ServiceType
 */
$arac = new \ServiceType\Arac($options);
/**
 * Sample call for aracMuayeneSorgula operation/method
 */
if ($arac->aracMuayeneSorgula(new \StructType\AracMuayeneSorgula()) !== false) {
    print_r($arac->getResult());
} else {
    print_r($arac->getLastError());
}
/**
 * Samples for Ip ServiceType
 */
$ip = new \ServiceType\Ip($options);
/**
 * Sample call for ipTanimla operation/method
 */
if ($ip->ipTanimla(new \StructType\IpTanimla()) !== false) {
    print_r($ip->getResult());
} else {
    print_r($ip->getLastError());
}
/**
 * Sample call for ipListele operation/method
 */
if ($ip->ipListele(new \StructType\IpListele()) !== false) {
    print_r($ip->getResult());
} else {
    print_r($ip->getLastError());
}
/**
 * Sample call for ipSil operation/method
 */
if ($ip->ipSil(new \StructType\IpSil()) !== false) {
    print_r($ip->getResult());
} else {
    print_r($ip->getLastError());
}
/**
 * Samples for Vize ServiceType
 */
$vize = new \ServiceType\Vize($options);
/**
 * Sample call for vizeOnBasvuru operation/method
 */
if ($vize->vizeOnBasvuru(new \StructType\VizeOnBasvuru()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruSurucuEkle operation/method
 */
if ($vize->vizeOnBasvuruSurucuEkle(new \StructType\VizeOnBasvuruSurucuEkle()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruIptal operation/method
 */
if ($vize->vizeOnBasvuruIptal(new \StructType\VizeOnBasvuruIptal()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruListele operation/method
 */
if ($vize->vizeOnBasvuruListele(new \StructType\VizeOnBasvuruListele()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Sample call for vizeOnBasvuruDetay operation/method
 */
if ($vize->vizeOnBasvuruDetay(new \StructType\VizeOnBasvuruDetay()) !== false) {
    print_r($vize->getResult());
} else {
    print_r($vize->getLastError());
}
/**
 * Samples for Param ServiceType
 */
$param = new \ServiceType\Param($options);
/**
 * Sample call for paramTehlikeliMaddeTasimaSekli operation/method
 */
if ($param->paramTehlikeliMaddeTasimaSekli(new \StructType\ParamTehlikeliMaddeTasimaSekli()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramYukBirimi operation/method
 */
if ($param->paramYukBirimi(new \StructType\ParamYukBirimi()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramYukTuru operation/method
 */
if ($param->paramYukTuru(new \StructType\ParamYukTuru()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Samples for Servis ServiceType
 */
$servis = new \ServiceType\Servis($options);
/**
 * Sample call for servisTest operation/method
 */
if ($servis->servisTest(new \StructType\ServisTest()) !== false) {
    print_r($servis->getResult());
} else {
    print_r($servis->getLastError());
}
/**
 * Samples for Yetki ServiceType
 */
$yetki = new \ServiceType\Yetki($options);
/**
 * Sample call for yetkiBelgesiKontrol operation/method
 */
if ($yetki->yetkiBelgesiKontrol(new \StructType\YetkiBelgesiKontrol()) !== false) {
    print_r($yetki->getResult());
} else {
    print_r($yetki->getLastError());
}
