<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sefer ServiceType
 * @subpackage Services
 */
class Sefer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named seferGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferGuncelle $parameters
     * @return \StructType\SeferGuncelleResponse|bool
     */
    public function seferGuncelle(\StructType\SeferGuncelle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferIptalEt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferIptalEt $parameters
     * @return \StructType\SeferIptalEtResponse|bool
     */
    public function seferIptalEt(\StructType\SeferIptalEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferIptalEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferAktifEt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferAktifEt $parameters
     * @return \StructType\SeferAktifEtResponse|bool
     */
    public function seferAktifEt(\StructType\SeferAktifEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferAktifEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferBildirimRaporu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferBildirimRaporu $parameters
     * @return \StructType\SeferBildirimRaporuResponse|bool
     */
    public function seferBildirimRaporu(\StructType\SeferBildirimRaporu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferBildirimRaporu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferBildirimOzeti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferBildirimOzeti $parameters
     * @return \StructType\SeferBildirimOzetiResponse|bool
     */
    public function seferBildirimOzeti(\StructType\SeferBildirimOzeti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferBildirimOzeti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SeferAktifEtResponse|\StructType\SeferBildirimOzetiResponse|\StructType\SeferBildirimRaporuResponse|\StructType\SeferGuncelleResponse|\StructType\SeferIptalEtResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
