<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ipSil StructType
 * Meta information extracted from the WSDL
 * - type: tns:ipSil
 * @subpackage Structs
 */
class IpSil extends AbstractStructBase
{
    /**
     * The wsuser
     * @var \StructType\UetdsYtsUser
     */
    public $wsuser;
    /**
     * The ipId
     * @var int
     */
    public $ipId;
    /**
     * Constructor method for ipSil
     * @uses IpSil::setWsuser()
     * @uses IpSil::setIpId()
     * @param \StructType\UetdsYtsUser $wsuser
     * @param int $ipId
     */
    public function __construct(\StructType\UetdsYtsUser $wsuser = null, $ipId = null)
    {
        $this
            ->setWsuser($wsuser)
            ->setIpId($ipId);
    }
    /**
     * Get wsuser value
     * @return \StructType\UetdsYtsUser|null
     */
    public function getWsuser()
    {
        return $this->wsuser;
    }
    /**
     * Set wsuser value
     * @param \StructType\UetdsYtsUser $wsuser
     * @return \StructType\IpSil
     */
    public function setWsuser(\StructType\UetdsYtsUser $wsuser = null)
    {
        $this->wsuser = $wsuser;
        return $this;
    }
    /**
     * Get ipId value
     * @return int|null
     */
    public function getIpId()
    {
        return $this->ipId;
    }
    /**
     * Set ipId value
     * @param int $ipId
     * @return \StructType\IpSil
     */
    public function setIpId($ipId = null)
    {
        // validation for constraint: int
        if (!is_null($ipId) && !(is_int($ipId) || ctype_digit($ipId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ipId, true), gettype($ipId)), __LINE__);
        }
        $this->ipId = $ipId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IpSil
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
