<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uetdsEsyaParamParaBirimiSonuc StructType
 * @subpackage Structs
 */
class UetdsEsyaParamParaBirimiSonuc extends AbstractStructBase
{
    /**
     * The sonucKodu
     * @var int
     */
    public $sonucKodu;
    /**
     * The sonucMesaji
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sonucMesaji;
    /**
     * The paraBirimiListesi
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParamEsyaTurListesi[]
     */
    public $paraBirimiListesi;
    /**
     * Constructor method for uetdsEsyaParamParaBirimiSonuc
     * @uses UetdsEsyaParamParaBirimiSonuc::setSonucKodu()
     * @uses UetdsEsyaParamParaBirimiSonuc::setSonucMesaji()
     * @uses UetdsEsyaParamParaBirimiSonuc::setParaBirimiListesi()
     * @param int $sonucKodu
     * @param string $sonucMesaji
     * @param \StructType\ParamEsyaTurListesi[] $paraBirimiListesi
     */
    public function __construct($sonucKodu = null, $sonucMesaji = null, array $paraBirimiListesi = array())
    {
        $this
            ->setSonucKodu($sonucKodu)
            ->setSonucMesaji($sonucMesaji)
            ->setParaBirimiListesi($paraBirimiListesi);
    }
    /**
     * Get sonucKodu value
     * @return int|null
     */
    public function getSonucKodu()
    {
        return $this->sonucKodu;
    }
    /**
     * Set sonucKodu value
     * @param int $sonucKodu
     * @return \StructType\UetdsEsyaParamParaBirimiSonuc
     */
    public function setSonucKodu($sonucKodu = null)
    {
        // validation for constraint: int
        if (!is_null($sonucKodu) && !(is_int($sonucKodu) || ctype_digit($sonucKodu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonucKodu, true), gettype($sonucKodu)), __LINE__);
        }
        $this->sonucKodu = $sonucKodu;
        return $this;
    }
    /**
     * Get sonucMesaji value
     * @return string|null
     */
    public function getSonucMesaji()
    {
        return $this->sonucMesaji;
    }
    /**
     * Set sonucMesaji value
     * @param string $sonucMesaji
     * @return \StructType\UetdsEsyaParamParaBirimiSonuc
     */
    public function setSonucMesaji($sonucMesaji = null)
    {
        // validation for constraint: string
        if (!is_null($sonucMesaji) && !is_string($sonucMesaji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonucMesaji, true), gettype($sonucMesaji)), __LINE__);
        }
        $this->sonucMesaji = $sonucMesaji;
        return $this;
    }
    /**
     * Get paraBirimiListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParamEsyaTurListesi[]|null
     */
    public function getParaBirimiListesi()
    {
        return isset($this->paraBirimiListesi) ? $this->paraBirimiListesi : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParaBirimiListesi method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParaBirimiListesi method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParaBirimiListesiForArrayConstraintsFromSetParaBirimiListesi(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uetdsEsyaParamParaBirimiSonucParaBirimiListesiItem) {
            // validation for constraint: itemType
            if (!$uetdsEsyaParamParaBirimiSonucParaBirimiListesiItem instanceof \StructType\ParamEsyaTurListesi) {
                $invalidValues[] = is_object($uetdsEsyaParamParaBirimiSonucParaBirimiListesiItem) ? get_class($uetdsEsyaParamParaBirimiSonucParaBirimiListesiItem) : sprintf('%s(%s)', gettype($uetdsEsyaParamParaBirimiSonucParaBirimiListesiItem), var_export($uetdsEsyaParamParaBirimiSonucParaBirimiListesiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paraBirimiListesi property can only contain items of type \StructType\ParamEsyaTurListesi, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paraBirimiListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParamEsyaTurListesi[] $paraBirimiListesi
     * @return \StructType\UetdsEsyaParamParaBirimiSonuc
     */
    public function setParaBirimiListesi(array $paraBirimiListesi = array())
    {
        // validation for constraint: array
        if ('' !== ($paraBirimiListesiArrayErrorMessage = self::validateParaBirimiListesiForArrayConstraintsFromSetParaBirimiListesi($paraBirimiListesi))) {
            throw new \InvalidArgumentException($paraBirimiListesiArrayErrorMessage, __LINE__);
        }
        if (is_null($paraBirimiListesi) || (is_array($paraBirimiListesi) && empty($paraBirimiListesi))) {
            unset($this->paraBirimiListesi);
        } else {
            $this->paraBirimiListesi = $paraBirimiListesi;
        }
        return $this;
    }
    /**
     * Add item to paraBirimiListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\ParamEsyaTurListesi $item
     * @return \StructType\UetdsEsyaParamParaBirimiSonuc
     */
    public function addToParaBirimiListesi(\StructType\ParamEsyaTurListesi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParamEsyaTurListesi) {
            throw new \InvalidArgumentException(sprintf('The paraBirimiListesi property can only contain items of type \StructType\ParamEsyaTurListesi, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paraBirimiListesi[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UetdsEsyaParamParaBirimiSonuc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
