<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servis.turkiye.gov.tr/services/g2g/kdgm/test/uetdsesya?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servis.turkiye.gov.tr/services/g2g/kdgm/test/uetdsesya?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Yuk ServiceType
 */
$yuk = new \ServiceType\Yuk($options);
/**
 * Sample call for yukBildirimiDetayi operation/method
 */
if ($yuk->yukBildirimiDetayi(new \StructType\YukBildirimiDetayi()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiGuncelle operation/method
 */
if ($yuk->yukBildirimiGuncelle(new \StructType\YukBildirimiGuncelle()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiIptalEt operation/method
 */
if ($yuk->yukBildirimiIptalEt(new \StructType\YukBildirimiIptalEt()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimRaporu operation/method
 */
if ($yuk->yukBildirimRaporu(new \StructType\YukBildirimRaporu()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Sample call for yukBildirimiListesi operation/method
 */
if ($yuk->yukBildirimiListesi(new \StructType\YukBildirimiListesi()) !== false) {
    print_r($yuk->getResult());
} else {
    print_r($yuk->getLastError());
}
/**
 * Samples for Param ServiceType
 */
$param = new \ServiceType\Param($options);
/**
 * Sample call for paramYukTuru operation/method
 */
if ($param->paramYukTuru(new \StructType\ParamYukTuru()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramTehlikeliMaddeTasimaSekli operation/method
 */
if ($param->paramTehlikeliMaddeTasimaSekli(new \StructType\ParamTehlikeliMaddeTasimaSekli()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Sample call for paramYukBirimi operation/method
 */
if ($param->paramYukBirimi(new \StructType\ParamYukBirimi()) !== false) {
    print_r($param->getResult());
} else {
    print_r($param->getLastError());
}
/**
 * Samples for Iptal ServiceType
 */
$iptal = new \ServiceType\Iptal($options);
/**
 * Sample call for iptalTurleri operation/method
 */
if ($iptal->iptalTurleri(new \StructType\IptalTurleri()) !== false) {
    print_r($iptal->getResult());
} else {
    print_r($iptal->getLastError());
}
/**
 * Samples for Servis ServiceType
 */
$servis = new \ServiceType\Servis($options);
/**
 * Sample call for servisTest operation/method
 */
if ($servis->servisTest(new \StructType\ServisTest()) !== false) {
    print_r($servis->getResult());
} else {
    print_r($servis->getLastError());
}
/**
 * Samples for Yetki ServiceType
 */
$yetki = new \ServiceType\Yetki($options);
/**
 * Sample call for yetkiBelgesiKontrol operation/method
 */
if ($yetki->yetkiBelgesiKontrol(new \StructType\YetkiBelgesiKontrol()) !== false) {
    print_r($yetki->getResult());
} else {
    print_r($yetki->getLastError());
}
/**
 * Samples for Mesleki ServiceType
 */
$mesleki = new \ServiceType\Mesleki($options);
/**
 * Sample call for meslekiYeterlilikSorgula operation/method
 */
if ($mesleki->meslekiYeterlilikSorgula(new \StructType\MeslekiYeterlilikSorgula()) !== false) {
    print_r($mesleki->getResult());
} else {
    print_r($mesleki->getLastError());
}
/**
 * Samples for Arac ServiceType
 */
$arac = new \ServiceType\Arac($options);
/**
 * Sample call for aracMuayeneSorgula operation/method
 */
if ($arac->aracMuayeneSorgula(new \StructType\AracMuayeneSorgula()) !== false) {
    print_r($arac->getResult());
} else {
    print_r($arac->getLastError());
}
/**
 * Samples for Yeni ServiceType
 */
$yeni = new \ServiceType\Yeni($options);
/**
 * Sample call for yeniYukKaydiBildir operation/method
 */
if ($yeni->yeniYukKaydiBildir(new \StructType\YeniYukKaydiBildir()) !== false) {
    print_r($yeni->getResult());
} else {
    print_r($yeni->getLastError());
}
