<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Yeni ServiceType
 * @subpackage Services
 */
class Yeni extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named yeniYukKaydiBildir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YeniYukKaydiBildir $parameters
     * @return \StructType\YeniYukKaydiBildirResponse|bool
     */
    public function yeniYukKaydiBildir(\StructType\YeniYukKaydiBildir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yeniYukKaydiBildir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\YeniYukKaydiBildirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
