<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Yuk ServiceType
 * @subpackage Services
 */
class Yuk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named yukBildirimiDetayi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukBildirimiDetayi $parameters
     * @return \StructType\YukBildirimiDetayiResponse|bool
     */
    public function yukBildirimiDetayi(\StructType\YukBildirimiDetayi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukBildirimiDetayi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named yukBildirimiGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukBildirimiGuncelle $parameters
     * @return \StructType\YukBildirimiGuncelleResponse|bool
     */
    public function yukBildirimiGuncelle(\StructType\YukBildirimiGuncelle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukBildirimiGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named yukBildirimiIptalEt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukBildirimiIptalEt $parameters
     * @return \StructType\YukBildirimiIptalEtResponse|bool
     */
    public function yukBildirimiIptalEt(\StructType\YukBildirimiIptalEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukBildirimiIptalEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named yukBildirimRaporu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukBildirimRaporu $parameters
     * @return \StructType\YukBildirimRaporuResponse|bool
     */
    public function yukBildirimRaporu(\StructType\YukBildirimRaporu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukBildirimRaporu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named yukBildirimiListesi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\YukBildirimiListesi $parameters
     * @return \StructType\YukBildirimiListesiResponse|bool
     */
    public function yukBildirimiListesi(\StructType\YukBildirimiListesi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->yukBildirimiListesi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\YukBildirimiDetayiResponse|\StructType\YukBildirimiGuncelleResponse|\StructType\YukBildirimiIptalEtResponse|\StructType\YukBildirimiListesiResponse|\StructType\YukBildirimRaporuResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
