<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retorna ServiceType
 * @subpackage Services
 */
class Retorna extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetornaEmpresasPorCNPJs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetornaEmpresasPorCNPJs $parameters
     * @return \StructType\RetornaEmpresasPorCNPJsResponse|bool
     */
    public function RetornaEmpresasPorCNPJs(\StructType\RetornaEmpresasPorCNPJs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetornaEmpresasPorCNPJs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetornaEmpresasPorCNPJsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
