<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enviar ServiceType
 * @subpackage Services
 */
class Enviar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnviarFlash
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarFlash $parameters
     * @return \StructType\EnviarFlashResponse|bool
     */
    public function EnviarFlash(\StructType\EnviarFlash $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarFlash($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarVendaFinalizadora
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarVendaFinalizadora $parameters
     * @return \StructType\EnviarVendaFinalizadoraResponse|bool
     */
    public function EnviarVendaFinalizadora(\StructType\EnviarVendaFinalizadora $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarVendaFinalizadora($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarVendaDia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarVendaDia $parameters
     * @return \StructType\EnviarVendaDiaResponse|bool
     */
    public function EnviarVendaDia(\StructType\EnviarVendaDia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarVendaDia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarVendaDiaFinalizadora
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarVendaDiaFinalizadora $parameters
     * @return \StructType\EnviarVendaDiaFinalizadoraResponse|bool
     */
    public function EnviarVendaDiaFinalizadora(\StructType\EnviarVendaDiaFinalizadora $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarVendaDiaFinalizadora($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarVendaSecao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarVendaSecao $parameters
     * @return \StructType\EnviarVendaSecaoResponse|bool
     */
    public function EnviarVendaSecao(\StructType\EnviarVendaSecao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarVendaSecao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarUsuarios
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarUsuarios $parameters
     * @return \StructType\EnviarUsuariosResponse|bool
     */
    public function EnviarUsuarios(\StructType\EnviarUsuarios $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarUsuarios($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnviarFlashResponse|\StructType\EnviarUsuariosResponse|\StructType\EnviarVendaDiaFinalizadoraResponse|\StructType\EnviarVendaDiaResponse|\StructType\EnviarVendaFinalizadoraResponse|\StructType\EnviarVendaSecaoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
