<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hello ServiceType
 */
$hello = new \ServiceType\Hello($options);
/**
 * Sample call for HelloWorld operation/method
 */
if ($hello->HelloWorld(new \StructType\HelloWorld()) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \ServiceType\Status($options);
/**
 * Sample call for Status operation/method
 */
if ($status->Status(new \StructType\Status()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Retorna ServiceType
 */
$retorna = new \ServiceType\Retorna($options);
/**
 * Sample call for RetornaEmpresasPorCNPJs operation/method
 */
if ($retorna->RetornaEmpresasPorCNPJs(new \StructType\RetornaEmpresasPorCNPJs()) !== false) {
    print_r($retorna->getResult());
} else {
    print_r($retorna->getLastError());
}
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
/**
 * Sample call for EnviarFlash operation/method
 */
if ($enviar->EnviarFlash(new \StructType\EnviarFlash()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarVendaFinalizadora operation/method
 */
if ($enviar->EnviarVendaFinalizadora(new \StructType\EnviarVendaFinalizadora()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarVendaDia operation/method
 */
if ($enviar->EnviarVendaDia(new \StructType\EnviarVendaDia()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarVendaDiaFinalizadora operation/method
 */
if ($enviar->EnviarVendaDiaFinalizadora(new \StructType\EnviarVendaDiaFinalizadora()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarVendaSecao operation/method
 */
if ($enviar->EnviarVendaSecao(new \StructType\EnviarVendaSecao()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarUsuarios operation/method
 */
if ($enviar->EnviarUsuarios(new \StructType\EnviarUsuarios()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Samples for Notificar ServiceType
 */
$notificar = new \ServiceType\Notificar($options);
/**
 * Sample call for NotificarDispositivos operation/method
 */
if ($notificar->NotificarDispositivos(new \StructType\NotificarDispositivos()) !== false) {
    print_r($notificar->getResult());
} else {
    print_r($notificar->getLastError());
}
/**
 * Samples for Carregar ServiceType
 */
$carregar = new \ServiceType\Carregar($options);
/**
 * Sample call for CarregarEmpresaPorCNPJ operation/method
 */
if ($carregar->CarregarEmpresaPorCNPJ(new \StructType\CarregarEmpresaPorCNPJ()) !== false) {
    print_r($carregar->getResult());
} else {
    print_r($carregar->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for LoginUsuario operation/method
 */
if ($login->LoginUsuario(new \StructType\LoginUsuario()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Retornar ServiceType
 */
$retornar = new \ServiceType\Retornar($options);
/**
 * Sample call for RetornarFlash operation/method
 */
if ($retornar->RetornarFlash(new \StructType\RetornarFlash()) !== false) {
    print_r($retornar->getResult());
} else {
    print_r($retornar->getLastError());
}
/**
 * Sample call for RetornarFinalizadora operation/method
 */
if ($retornar->RetornarFinalizadora(new \StructType\RetornarFinalizadora()) !== false) {
    print_r($retornar->getResult());
} else {
    print_r($retornar->getLastError());
}
/**
 * Sample call for RetornarVendaSecao operation/method
 */
if ($retornar->RetornarVendaSecao(new \StructType\RetornarVendaSecao()) !== false) {
    print_r($retornar->getResult());
} else {
    print_r($retornar->getLastError());
}
/**
 * Sample call for RetornarVendaDia operation/method
 */
if ($retornar->RetornarVendaDia(new \StructType\RetornarVendaDia()) !== false) {
    print_r($retornar->getResult());
} else {
    print_r($retornar->getLastError());
}
/**
 * Samples for Desconectar ServiceType
 */
$desconectar = new \ServiceType\Desconectar($options);
/**
 * Sample call for DesconectarEmpresa operation/method
 */
if ($desconectar->DesconectarEmpresa(new \StructType\DesconectarEmpresa()) !== false) {
    print_r($desconectar->getResult());
} else {
    print_r($desconectar->getLastError());
}
