<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarregarEmpresaPorCNPJ StructType
 * @subpackage Structs
 */
class CarregarEmpresaPorCNPJ extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The guid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * The dispositivo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dispositivo;
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * Constructor method for CarregarEmpresaPorCNPJ
     * @uses CarregarEmpresaPorCNPJ::setUsuario()
     * @uses CarregarEmpresaPorCNPJ::setSenha()
     * @uses CarregarEmpresaPorCNPJ::setGuid()
     * @uses CarregarEmpresaPorCNPJ::setDispositivo()
     * @uses CarregarEmpresaPorCNPJ::setCnpj()
     * @param string $usuario
     * @param string $senha
     * @param string $guid
     * @param string $dispositivo
     * @param string $cnpj
     */
    public function __construct($usuario = null, $senha = null, $guid = null, $dispositivo = null, $cnpj = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setGuid($guid)
            ->setDispositivo($dispositivo)
            ->setCnpj($cnpj);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\CarregarEmpresaPorCNPJ
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\CarregarEmpresaPorCNPJ
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\CarregarEmpresaPorCNPJ
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get dispositivo value
     * @return string|null
     */
    public function getDispositivo()
    {
        return $this->dispositivo;
    }
    /**
     * Set dispositivo value
     * @param string $dispositivo
     * @return \StructType\CarregarEmpresaPorCNPJ
     */
    public function setDispositivo($dispositivo = null)
    {
        // validation for constraint: string
        if (!is_null($dispositivo) && !is_string($dispositivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispositivo, true), gettype($dispositivo)), __LINE__);
        }
        $this->dispositivo = $dispositivo;
        return $this;
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\CarregarEmpresaPorCNPJ
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarregarEmpresaPorCNPJ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
