<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retornar ServiceType
 * @subpackage Services
 */
class Retornar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetornarFlash
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetornarFlash $parameters
     * @return \StructType\RetornarFlashResponse|bool
     */
    public function RetornarFlash(\StructType\RetornarFlash $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetornarFlash($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetornarFinalizadora
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetornarFinalizadora $parameters
     * @return \StructType\RetornarFinalizadoraResponse|bool
     */
    public function RetornarFinalizadora(\StructType\RetornarFinalizadora $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetornarFinalizadora($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetornarVendaSecao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetornarVendaSecao $parameters
     * @return \StructType\RetornarVendaSecaoResponse|bool
     */
    public function RetornarVendaSecao(\StructType\RetornarVendaSecao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetornarVendaSecao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetornarVendaDia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetornarVendaDia $parameters
     * @return \StructType\RetornarVendaDiaResponse|bool
     */
    public function RetornarVendaDia(\StructType\RetornarVendaDia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetornarVendaDia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetornarFinalizadoraResponse|\StructType\RetornarFlashResponse|\StructType\RetornarVendaDiaResponse|\StructType\RetornarVendaSecaoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
