<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Carregar ServiceType
 * @subpackage Services
 */
class Carregar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CarregarEmpresaPorCNPJ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CarregarEmpresaPorCNPJ $parameters
     * @return \StructType\CarregarEmpresaPorCNPJResponse|bool
     */
    public function CarregarEmpresaPorCNPJ(\StructType\CarregarEmpresaPorCNPJ $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CarregarEmpresaPorCNPJ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CarregarEmpresaPorCNPJResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
