<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Desconectar ServiceType
 * @subpackage Services
 */
class Desconectar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DesconectarEmpresa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesconectarEmpresa $parameters
     * @return \StructType\DesconectarEmpresaResponse|bool
     */
    public function DesconectarEmpresa(\StructType\DesconectarEmpresa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesconectarEmpresa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DesconectarEmpresaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
