<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transferstypesplaces ServiceType
 * @subpackage Services
 */
class Transferstypesplaces extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named transfers_types_places
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Auth $auth
     * @return \StructType\TransferTypePlaceWSDO[]|bool
     */
    public function transfers_types_places(\StructType\Auth $auth)
    {
        try {
            $this->setResult($this->getSoapClient()->transfers_types_places($auth));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransferTypePlaceWSDO[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
