<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Boats ServiceType
 * @subpackage Services
 */
class Boats extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named boats
     * Meta information extracted from the WSDL
     * - documentation: @param Auth $auth
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Auth $auth
     * @param string $country_zone_id
     * @param string $zone_id
     * @return Array|bool
     */
    public function boats(\StructType\Auth $auth, $country_zone_id, $zone_id)
    {
        try {
            $this->setResult($this->getSoapClient()->boats($auth, $country_zone_id, $zone_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return Array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
