<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transfersdestinations ServiceType
 * @subpackage Services
 */
class Transfersdestinations extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named transfers_destinations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Auth $auth
     * @param string $supplier_id
     * @param string $flight
     * @return \StructType\TransferPlaceSupplierWSDO[]|bool
     */
    public function transfers_destinations(\StructType\Auth $auth, $supplier_id, $flight)
    {
        try {
            $this->setResult($this->getSoapClient()->transfers_destinations($auth, $supplier_id, $flight));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransferPlaceSupplierWSDO[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
