<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelShipment StructType
 * Meta information extracted from the WSDL
 * - type: tns:cancelShipment
 * @subpackage Structs
 */
class CancelShipment extends AbstractStructBase
{
    /**
     * The wsUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsUserName;
    /**
     * The wsPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wsPassword;
    /**
     * The userLanguage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userLanguage;
    /**
     * The cargoKeys
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $cargoKeys;
    /**
     * Constructor method for cancelShipment
     * @uses CancelShipment::setWsUserName()
     * @uses CancelShipment::setWsPassword()
     * @uses CancelShipment::setUserLanguage()
     * @uses CancelShipment::setCargoKeys()
     * @param string $wsUserName
     * @param string $wsPassword
     * @param string $userLanguage
     * @param string[] $cargoKeys
     */
    public function __construct($wsUserName = null, $wsPassword = null, $userLanguage = null, array $cargoKeys = array())
    {
        $this
            ->setWsUserName($wsUserName)
            ->setWsPassword($wsPassword)
            ->setUserLanguage($userLanguage)
            ->setCargoKeys($cargoKeys);
    }
    /**
     * Get wsUserName value
     * @return string|null
     */
    public function getWsUserName()
    {
        return $this->wsUserName;
    }
    /**
     * Set wsUserName value
     * @param string $wsUserName
     * @return \StructType\CancelShipment
     */
    public function setWsUserName($wsUserName = null)
    {
        // validation for constraint: string
        if (!is_null($wsUserName) && !is_string($wsUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsUserName, true), gettype($wsUserName)), __LINE__);
        }
        $this->wsUserName = $wsUserName;
        return $this;
    }
    /**
     * Get wsPassword value
     * @return string|null
     */
    public function getWsPassword()
    {
        return $this->wsPassword;
    }
    /**
     * Set wsPassword value
     * @param string $wsPassword
     * @return \StructType\CancelShipment
     */
    public function setWsPassword($wsPassword = null)
    {
        // validation for constraint: string
        if (!is_null($wsPassword) && !is_string($wsPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsPassword, true), gettype($wsPassword)), __LINE__);
        }
        $this->wsPassword = $wsPassword;
        return $this;
    }
    /**
     * Get userLanguage value
     * @return string|null
     */
    public function getUserLanguage()
    {
        return $this->userLanguage;
    }
    /**
     * Set userLanguage value
     * @param string $userLanguage
     * @return \StructType\CancelShipment
     */
    public function setUserLanguage($userLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($userLanguage) && !is_string($userLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLanguage, true), gettype($userLanguage)), __LINE__);
        }
        $this->userLanguage = $userLanguage;
        return $this;
    }
    /**
     * Get cargoKeys value
     * @return string[]|null
     */
    public function getCargoKeys()
    {
        return $this->cargoKeys;
    }
    /**
     * This method is responsible for validating the values passed to the setCargoKeys method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCargoKeys method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCargoKeysForArrayConstraintsFromSetCargoKeys(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelShipmentCargoKeysItem) {
            // validation for constraint: itemType
            if (!is_string($cancelShipmentCargoKeysItem)) {
                $invalidValues[] = is_object($cancelShipmentCargoKeysItem) ? get_class($cancelShipmentCargoKeysItem) : sprintf('%s(%s)', gettype($cancelShipmentCargoKeysItem), var_export($cancelShipmentCargoKeysItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cargoKeys property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cargoKeys value
     * @throws \InvalidArgumentException
     * @param string[] $cargoKeys
     * @return \StructType\CancelShipment
     */
    public function setCargoKeys(array $cargoKeys = array())
    {
        // validation for constraint: array
        if ('' !== ($cargoKeysArrayErrorMessage = self::validateCargoKeysForArrayConstraintsFromSetCargoKeys($cargoKeys))) {
            throw new \InvalidArgumentException($cargoKeysArrayErrorMessage, __LINE__);
        }
        $this->cargoKeys = $cargoKeys;
        return $this;
    }
    /**
     * Add item to cargoKeys value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CancelShipment
     */
    public function addToCargoKeys($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The cargoKeys property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cargoKeys[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
