<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingOrderDetailVO StructType
 * @subpackage Structs
 */
class ShippingOrderDetailVO extends AbstractStructBase
{
    /**
     * The cargoKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoKey;
    /**
     * The errCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $errCode;
    /**
     * The errMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errMessage;
    /**
     * The invoiceKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceKey;
    /**
     * Constructor method for shippingOrderDetailVO
     * @uses ShippingOrderDetailVO::setCargoKey()
     * @uses ShippingOrderDetailVO::setErrCode()
     * @uses ShippingOrderDetailVO::setErrMessage()
     * @uses ShippingOrderDetailVO::setInvoiceKey()
     * @param string $cargoKey
     * @param int $errCode
     * @param string $errMessage
     * @param string $invoiceKey
     */
    public function __construct($cargoKey = null, $errCode = null, $errMessage = null, $invoiceKey = null)
    {
        $this
            ->setCargoKey($cargoKey)
            ->setErrCode($errCode)
            ->setErrMessage($errMessage)
            ->setInvoiceKey($invoiceKey);
    }
    /**
     * Get cargoKey value
     * @return string|null
     */
    public function getCargoKey()
    {
        return $this->cargoKey;
    }
    /**
     * Set cargoKey value
     * @param string $cargoKey
     * @return \StructType\ShippingOrderDetailVO
     */
    public function setCargoKey($cargoKey = null)
    {
        // validation for constraint: string
        if (!is_null($cargoKey) && !is_string($cargoKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoKey, true), gettype($cargoKey)), __LINE__);
        }
        $this->cargoKey = $cargoKey;
        return $this;
    }
    /**
     * Get errCode value
     * @return int|null
     */
    public function getErrCode()
    {
        return $this->errCode;
    }
    /**
     * Set errCode value
     * @param int $errCode
     * @return \StructType\ShippingOrderDetailVO
     */
    public function setErrCode($errCode = null)
    {
        // validation for constraint: int
        if (!is_null($errCode) && !(is_int($errCode) || ctype_digit($errCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errCode, true), gettype($errCode)), __LINE__);
        }
        $this->errCode = $errCode;
        return $this;
    }
    /**
     * Get errMessage value
     * @return string|null
     */
    public function getErrMessage()
    {
        return $this->errMessage;
    }
    /**
     * Set errMessage value
     * @param string $errMessage
     * @return \StructType\ShippingOrderDetailVO
     */
    public function setErrMessage($errMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errMessage) && !is_string($errMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errMessage, true), gettype($errMessage)), __LINE__);
        }
        $this->errMessage = $errMessage;
        return $this;
    }
    /**
     * Get invoiceKey value
     * @return string|null
     */
    public function getInvoiceKey()
    {
        return $this->invoiceKey;
    }
    /**
     * Set invoiceKey value
     * @param string $invoiceKey
     * @return \StructType\ShippingOrderDetailVO
     */
    public function setInvoiceKey($invoiceKey = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceKey) && !is_string($invoiceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceKey, true), gettype($invoiceKey)), __LINE__);
        }
        $this->invoiceKey = $invoiceKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingOrderDetailVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
