<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Start StructType
 * @subpackage Services
 */
class Start extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StartSignature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param StartSignature $parameters
     * @return StartSignatureResponse|bool
     */
    public function StartSignature(StartSignature $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartSignature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StartSignatureTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param StartSignatureTemplate $parameters
     * @return StartSignatureTemplateResponse|bool
     */
    public function StartSignatureTemplate(StartSignatureTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartSignatureTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StartSignatureTemplateEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param StartSignatureTemplateEx $parameters
     * @return StartSignatureTemplateExResponse|bool
     */
    public function StartSignatureTemplateEx(StartSignatureTemplateEx $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartSignatureTemplateEx($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StartBatchSignature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param StartBatchSignature $parameters
     * @return StartBatchSignatureResponse|bool
     */
    public function StartBatchSignature(StartBatchSignature $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StartBatchSignature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return StartBatchSignatureResponse|StartSignatureResponse|StartSignatureTemplateExResponse|StartSignatureTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
