<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTemplate StructType
 * @subpackage Structs
 */
class GetTemplate extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $APIKey;
    /**
     * The SigTemplateId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SigTemplateId;
    /**
     * Constructor method for GetTemplate
     * @uses GetTemplate::setAPIKey()
     * @uses GetTemplate::setSigTemplateId()
     * @param string $aPIKey
     * @param int $sigTemplateId
     */
    public function __construct($aPIKey = null, $sigTemplateId = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setSigTemplateId($sigTemplateId);
    }
    /**
     * Get APIKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAPIKey()
    {
        return isset($this->APIKey) ? $this->APIKey : null;
    }
    /**
     * Set APIKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aPIKey
     * @return GetTemplate
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIKey, true), gettype($aPIKey)), __LINE__);
        }
        if (is_null($aPIKey) || (is_array($aPIKey) && empty($aPIKey))) {
            unset($this->APIKey);
        } else {
            $this->APIKey = $aPIKey;
        }
        return $this;
    }
    /**
     * Get SigTemplateId value
     * @return int|null
     */
    public function getSigTemplateId()
    {
        return $this->SigTemplateId;
    }
    /**
     * Set SigTemplateId value
     * @param int $sigTemplateId
     * @return GetTemplate
     */
    public function setSigTemplateId($sigTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($sigTemplateId) && !(is_int($sigTemplateId) || ctype_digit($sigTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sigTemplateId, true), gettype($sigTemplateId)), __LINE__);
        }
        $this->SigTemplateId = $sigTemplateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
