<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndBatchSignatureResponse StructType
 * @subpackage Structs
 */
class EndBatchSignatureResponse extends AbstractStructBase
{
    /**
     * The EndBatchSignatureResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EndBatchSignatureResult;
    /**
     * The HandySignaturUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandySignaturUrl;
    /**
     * Constructor method for EndBatchSignatureResponse
     * @uses EndBatchSignatureResponse::setEndBatchSignatureResult()
     * @uses EndBatchSignatureResponse::setHandySignaturUrl()
     * @param int $endBatchSignatureResult
     * @param string $handySignaturUrl
     */
    public function __construct($endBatchSignatureResult = null, $handySignaturUrl = null)
    {
        $this
            ->setEndBatchSignatureResult($endBatchSignatureResult)
            ->setHandySignaturUrl($handySignaturUrl);
    }
    /**
     * Get EndBatchSignatureResult value
     * @return int|null
     */
    public function getEndBatchSignatureResult()
    {
        return $this->EndBatchSignatureResult;
    }
    /**
     * Set EndBatchSignatureResult value
     * @param int $endBatchSignatureResult
     * @return EndBatchSignatureResponse
     */
    public function setEndBatchSignatureResult($endBatchSignatureResult = null)
    {
        // validation for constraint: int
        if (!is_null($endBatchSignatureResult) && !(is_int($endBatchSignatureResult) || ctype_digit($endBatchSignatureResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endBatchSignatureResult, true), gettype($endBatchSignatureResult)), __LINE__);
        }
        $this->EndBatchSignatureResult = $endBatchSignatureResult;
        return $this;
    }
    /**
     * Get HandySignaturUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandySignaturUrl()
    {
        return isset($this->HandySignaturUrl) ? $this->HandySignaturUrl : null;
    }
    /**
     * Set HandySignaturUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handySignaturUrl
     * @return EndBatchSignatureResponse
     */
    public function setHandySignaturUrl($handySignaturUrl = null)
    {
        // validation for constraint: string
        if (!is_null($handySignaturUrl) && !is_string($handySignaturUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handySignaturUrl, true), gettype($handySignaturUrl)), __LINE__);
        }
        if (is_null($handySignaturUrl) || (is_array($handySignaturUrl) && empty($handySignaturUrl))) {
            unset($this->HandySignaturUrl);
        } else {
            $this->HandySignaturUrl = $handySignaturUrl;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return EndBatchSignatureResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
