<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoP12Signature StructType
 * @subpackage Structs
 */
class DoP12Signature extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $APIKey;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentData;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentName;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for DoP12Signature
     * @uses DoP12Signature::setAPIKey()
     * @uses DoP12Signature::setDocumentData()
     * @uses DoP12Signature::setDocumentName()
     * @uses DoP12Signature::setLocation()
     * @uses DoP12Signature::setReason()
     * @param string $aPIKey
     * @param string $documentData
     * @param string $documentName
     * @param string $location
     * @param string $reason
     */
    public function __construct($aPIKey = null, $documentData = null, $documentName = null, $location = null, $reason = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setDocumentData($documentData)
            ->setDocumentName($documentName)
            ->setLocation($location)
            ->setReason($reason);
    }
    /**
     * Get APIKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAPIKey()
    {
        return isset($this->APIKey) ? $this->APIKey : null;
    }
    /**
     * Set APIKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aPIKey
     * @return DoP12Signature
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIKey, true), gettype($aPIKey)), __LINE__);
        }
        if (is_null($aPIKey) || (is_array($aPIKey) && empty($aPIKey))) {
            unset($this->APIKey);
        } else {
            $this->APIKey = $aPIKey;
        }
        return $this;
    }
    /**
     * Get DocumentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentData()
    {
        return isset($this->DocumentData) ? $this->DocumentData : null;
    }
    /**
     * Set DocumentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentData
     * @return DoP12Signature
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        if (is_null($documentData) || (is_array($documentData) && empty($documentData))) {
            unset($this->DocumentData);
        } else {
            $this->DocumentData = $documentData;
        }
        return $this;
    }
    /**
     * Get DocumentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentName()
    {
        return isset($this->DocumentName) ? $this->DocumentName : null;
    }
    /**
     * Set DocumentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentName
     * @return DoP12Signature
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        if (is_null($documentName) || (is_array($documentName) && empty($documentName))) {
            unset($this->DocumentName);
        } else {
            $this->DocumentName = $documentName;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return DoP12Signature
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReason()
    {
        return isset($this->Reason) ? $this->Reason : null;
    }
    /**
     * Set Reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reason
     * @return DoP12Signature
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->Reason);
        } else {
            $this->Reason = $reason;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoP12Signature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
