<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentResponse StructType
 * @subpackage Structs
 */
class GetDocumentResponse extends AbstractStructBase
{
    /**
     * The GetDocumentResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GetDocumentResult;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentName;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentData;
    /**
     * Constructor method for GetDocumentResponse
     * @uses GetDocumentResponse::setGetDocumentResult()
     * @uses GetDocumentResponse::setDocumentName()
     * @uses GetDocumentResponse::setDocumentData()
     * @param int $getDocumentResult
     * @param string $documentName
     * @param string $documentData
     */
    public function __construct($getDocumentResult = null, $documentName = null, $documentData = null)
    {
        $this
            ->setGetDocumentResult($getDocumentResult)
            ->setDocumentName($documentName)
            ->setDocumentData($documentData);
    }
    /**
     * Get GetDocumentResult value
     * @return int|null
     */
    public function getGetDocumentResult()
    {
        return $this->GetDocumentResult;
    }
    /**
     * Set GetDocumentResult value
     * @param int $getDocumentResult
     * @return GetDocumentResponse
     */
    public function setGetDocumentResult($getDocumentResult = null)
    {
        // validation for constraint: int
        if (!is_null($getDocumentResult) && !(is_int($getDocumentResult) || ctype_digit($getDocumentResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($getDocumentResult, true), gettype($getDocumentResult)), __LINE__);
        }
        $this->GetDocumentResult = $getDocumentResult;
        return $this;
    }
    /**
     * Get DocumentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentName()
    {
        return isset($this->DocumentName) ? $this->DocumentName : null;
    }
    /**
     * Set DocumentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentName
     * @return GetDocumentResponse
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        if (is_null($documentName) || (is_array($documentName) && empty($documentName))) {
            unset($this->DocumentName);
        } else {
            $this->DocumentName = $documentName;
        }
        return $this;
    }
    /**
     * Get DocumentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentData()
    {
        return isset($this->DocumentData) ? $this->DocumentData : null;
    }
    /**
     * Set DocumentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentData
     * @return GetDocumentResponse
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        if (is_null($documentData) || (is_array($documentData) && empty($documentData))) {
            unset($this->DocumentData);
        } else {
            $this->DocumentData = $documentData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetDocumentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
