<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndSignatureResponse StructType
 * @subpackage Structs
 */
class EndSignatureResponse extends AbstractStructBase
{
    /**
     * The EndSignatureResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EndSignatureResult;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentName;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentData;
    /**
     * The CertificateB64
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CertificateB64;
    /**
     * Constructor method for EndSignatureResponse
     * @uses EndSignatureResponse::setEndSignatureResult()
     * @uses EndSignatureResponse::setDocumentName()
     * @uses EndSignatureResponse::setDocumentData()
     * @uses EndSignatureResponse::setCertificateB64()
     * @param int $endSignatureResult
     * @param string $documentName
     * @param string $documentData
     * @param string $certificateB64
     */
    public function __construct($endSignatureResult = null, $documentName = null, $documentData = null, $certificateB64 = null)
    {
        $this
            ->setEndSignatureResult($endSignatureResult)
            ->setDocumentName($documentName)
            ->setDocumentData($documentData)
            ->setCertificateB64($certificateB64);
    }
    /**
     * Get EndSignatureResult value
     * @return int|null
     */
    public function getEndSignatureResult()
    {
        return $this->EndSignatureResult;
    }
    /**
     * Set EndSignatureResult value
     * @param int $endSignatureResult
     * @return EndSignatureResponse
     */
    public function setEndSignatureResult($endSignatureResult = null)
    {
        // validation for constraint: int
        if (!is_null($endSignatureResult) && !(is_int($endSignatureResult) || ctype_digit($endSignatureResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endSignatureResult, true), gettype($endSignatureResult)), __LINE__);
        }
        $this->EndSignatureResult = $endSignatureResult;
        return $this;
    }
    /**
     * Get DocumentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentName()
    {
        return isset($this->DocumentName) ? $this->DocumentName : null;
    }
    /**
     * Set DocumentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentName
     * @return EndSignatureResponse
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        if (is_null($documentName) || (is_array($documentName) && empty($documentName))) {
            unset($this->DocumentName);
        } else {
            $this->DocumentName = $documentName;
        }
        return $this;
    }
    /**
     * Get DocumentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentData()
    {
        return isset($this->DocumentData) ? $this->DocumentData : null;
    }
    /**
     * Set DocumentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentData
     * @return EndSignatureResponse
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        if (is_null($documentData) || (is_array($documentData) && empty($documentData))) {
            unset($this->DocumentData);
        } else {
            $this->DocumentData = $documentData;
        }
        return $this;
    }
    /**
     * Get CertificateB64 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertificateB64()
    {
        return isset($this->CertificateB64) ? $this->CertificateB64 : null;
    }
    /**
     * Set CertificateB64 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $certificateB64
     * @return EndSignatureResponse
     */
    public function setCertificateB64($certificateB64 = null)
    {
        // validation for constraint: string
        if (!is_null($certificateB64) && !is_string($certificateB64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificateB64, true), gettype($certificateB64)), __LINE__);
        }
        if (is_null($certificateB64) || (is_array($certificateB64) && empty($certificateB64))) {
            unset($this->CertificateB64);
        } else {
            $this->CertificateB64 = $certificateB64;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return EndSignatureResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
