<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoP12SignatureTemplateExResponse StructType
 * @subpackage Structs
 */
class DoP12SignatureTemplateExResponse extends AbstractStructBase
{
    /**
     * The DoP12SignatureTemplateExResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DoP12SignatureTemplateExResult;
    /**
     * The SignedDocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SignedDocumentData;
    /**
     * Constructor method for DoP12SignatureTemplateExResponse
     * @uses DoP12SignatureTemplateExResponse::setDoP12SignatureTemplateExResult()
     * @uses DoP12SignatureTemplateExResponse::setSignedDocumentData()
     * @param int $doP12SignatureTemplateExResult
     * @param string $signedDocumentData
     */
    public function __construct($doP12SignatureTemplateExResult = null, $signedDocumentData = null)
    {
        $this
            ->setDoP12SignatureTemplateExResult($doP12SignatureTemplateExResult)
            ->setSignedDocumentData($signedDocumentData);
    }
    /**
     * Get DoP12SignatureTemplateExResult value
     * @return int|null
     */
    public function getDoP12SignatureTemplateExResult()
    {
        return $this->DoP12SignatureTemplateExResult;
    }
    /**
     * Set DoP12SignatureTemplateExResult value
     * @param int $doP12SignatureTemplateExResult
     * @return DoP12SignatureTemplateExResponse
     */
    public function setDoP12SignatureTemplateExResult($doP12SignatureTemplateExResult = null)
    {
        // validation for constraint: int
        if (!is_null($doP12SignatureTemplateExResult) && !(is_int($doP12SignatureTemplateExResult) || ctype_digit($doP12SignatureTemplateExResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doP12SignatureTemplateExResult, true), gettype($doP12SignatureTemplateExResult)), __LINE__);
        }
        $this->DoP12SignatureTemplateExResult = $doP12SignatureTemplateExResult;
        return $this;
    }
    /**
     * Get SignedDocumentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignedDocumentData()
    {
        return isset($this->SignedDocumentData) ? $this->SignedDocumentData : null;
    }
    /**
     * Set SignedDocumentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signedDocumentData
     * @return DoP12SignatureTemplateExResponse
     */
    public function setSignedDocumentData($signedDocumentData = null)
    {
        // validation for constraint: string
        if (!is_null($signedDocumentData) && !is_string($signedDocumentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signedDocumentData, true), gettype($signedDocumentData)), __LINE__);
        }
        if (is_null($signedDocumentData) || (is_array($signedDocumentData) && empty($signedDocumentData))) {
            unset($this->SignedDocumentData);
        } else {
            $this->SignedDocumentData = $signedDocumentData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoP12SignatureTemplateExResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
