<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDocumentTemplateEx StructType
 * @subpackage Structs
 */
class AddDocumentTemplateEx extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $APIKey;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ticket;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentData;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentName;
    /**
     * The TemplateId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TemplateId;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reason;
    /**
     * The X0
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $X0;
    /**
     * The Y0
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Y0;
    /**
     * The X1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $X1;
    /**
     * The Y1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Y1;
    /**
     * The Page
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Page;
    /**
     * Constructor method for AddDocumentTemplateEx
     * @uses AddDocumentTemplateEx::setAPIKey()
     * @uses AddDocumentTemplateEx::setTicket()
     * @uses AddDocumentTemplateEx::setDocumentData()
     * @uses AddDocumentTemplateEx::setDocumentName()
     * @uses AddDocumentTemplateEx::setTemplateId()
     * @uses AddDocumentTemplateEx::setLocation()
     * @uses AddDocumentTemplateEx::setReason()
     * @uses AddDocumentTemplateEx::setX0()
     * @uses AddDocumentTemplateEx::setY0()
     * @uses AddDocumentTemplateEx::setX1()
     * @uses AddDocumentTemplateEx::setY1()
     * @uses AddDocumentTemplateEx::setPage()
     * @param string $aPIKey
     * @param string $ticket
     * @param string $documentData
     * @param string $documentName
     * @param int $templateId
     * @param string $location
     * @param string $reason
     * @param float $x0
     * @param float $y0
     * @param float $x1
     * @param float $y1
     * @param int $page
     */
    public function __construct($aPIKey = null, $ticket = null, $documentData = null, $documentName = null, $templateId = null, $location = null, $reason = null, $x0 = null, $y0 = null, $x1 = null, $y1 = null, $page = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setTicket($ticket)
            ->setDocumentData($documentData)
            ->setDocumentName($documentName)
            ->setTemplateId($templateId)
            ->setLocation($location)
            ->setReason($reason)
            ->setX0($x0)
            ->setY0($y0)
            ->setX1($x1)
            ->setY1($y1)
            ->setPage($page);
    }
    /**
     * Get APIKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAPIKey()
    {
        return isset($this->APIKey) ? $this->APIKey : null;
    }
    /**
     * Set APIKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aPIKey
     * @return AddDocumentTemplateEx
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIKey, true), gettype($aPIKey)), __LINE__);
        }
        if (is_null($aPIKey) || (is_array($aPIKey) && empty($aPIKey))) {
            unset($this->APIKey);
        } else {
            $this->APIKey = $aPIKey;
        }
        return $this;
    }
    /**
     * Get Ticket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicket()
    {
        return isset($this->Ticket) ? $this->Ticket : null;
    }
    /**
     * Set Ticket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticket
     * @return AddDocumentTemplateEx
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        if (is_null($ticket) || (is_array($ticket) && empty($ticket))) {
            unset($this->Ticket);
        } else {
            $this->Ticket = $ticket;
        }
        return $this;
    }
    /**
     * Get DocumentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentData()
    {
        return isset($this->DocumentData) ? $this->DocumentData : null;
    }
    /**
     * Set DocumentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentData
     * @return AddDocumentTemplateEx
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        if (is_null($documentData) || (is_array($documentData) && empty($documentData))) {
            unset($this->DocumentData);
        } else {
            $this->DocumentData = $documentData;
        }
        return $this;
    }
    /**
     * Get DocumentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentName()
    {
        return isset($this->DocumentName) ? $this->DocumentName : null;
    }
    /**
     * Set DocumentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentName
     * @return AddDocumentTemplateEx
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        if (is_null($documentName) || (is_array($documentName) && empty($documentName))) {
            unset($this->DocumentName);
        } else {
            $this->DocumentName = $documentName;
        }
        return $this;
    }
    /**
     * Get TemplateId value
     * @return int|null
     */
    public function getTemplateId()
    {
        return $this->TemplateId;
    }
    /**
     * Set TemplateId value
     * @param int $templateId
     * @return AddDocumentTemplateEx
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: int
        if (!is_null($templateId) && !(is_int($templateId) || ctype_digit($templateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateId, true), gettype($templateId)), __LINE__);
        }
        $this->TemplateId = $templateId;
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return AddDocumentTemplateEx
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReason()
    {
        return isset($this->Reason) ? $this->Reason : null;
    }
    /**
     * Set Reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reason
     * @return AddDocumentTemplateEx
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->Reason);
        } else {
            $this->Reason = $reason;
        }
        return $this;
    }
    /**
     * Get X0 value
     * @return float|null
     */
    public function getX0()
    {
        return $this->X0;
    }
    /**
     * Set X0 value
     * @param float $x0
     * @return AddDocumentTemplateEx
     */
    public function setX0($x0 = null)
    {
        // validation for constraint: float
        if (!is_null($x0) && !(is_float($x0) || is_numeric($x0))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($x0, true), gettype($x0)), __LINE__);
        }
        $this->X0 = $x0;
        return $this;
    }
    /**
     * Get Y0 value
     * @return float|null
     */
    public function getY0()
    {
        return $this->Y0;
    }
    /**
     * Set Y0 value
     * @param float $y0
     * @return AddDocumentTemplateEx
     */
    public function setY0($y0 = null)
    {
        // validation for constraint: float
        if (!is_null($y0) && !(is_float($y0) || is_numeric($y0))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($y0, true), gettype($y0)), __LINE__);
        }
        $this->Y0 = $y0;
        return $this;
    }
    /**
     * Get X1 value
     * @return float|null
     */
    public function getX1()
    {
        return $this->X1;
    }
    /**
     * Set X1 value
     * @param float $x1
     * @return AddDocumentTemplateEx
     */
    public function setX1($x1 = null)
    {
        // validation for constraint: float
        if (!is_null($x1) && !(is_float($x1) || is_numeric($x1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($x1, true), gettype($x1)), __LINE__);
        }
        $this->X1 = $x1;
        return $this;
    }
    /**
     * Get Y1 value
     * @return float|null
     */
    public function getY1()
    {
        return $this->Y1;
    }
    /**
     * Set Y1 value
     * @param float $y1
     * @return AddDocumentTemplateEx
     */
    public function setY1($y1 = null)
    {
        // validation for constraint: float
        if (!is_null($y1) && !(is_float($y1) || is_numeric($y1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($y1, true), gettype($y1)), __LINE__);
        }
        $this->Y1 = $y1;
        return $this;
    }
    /**
     * Get Page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return AddDocumentTemplateEx
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AddDocumentTemplateEx
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
