<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartSignatureTemplateResponse StructType
 * @subpackage Structs
 */
class StartSignatureTemplateResponse extends AbstractStructBase
{
    /**
     * The StartSignatureTemplateResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StartSignatureTemplateResult;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ticket;
    /**
     * The HandySignaturUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandySignaturUrl;
    /**
     * Constructor method for StartSignatureTemplateResponse
     * @uses StartSignatureTemplateResponse::setStartSignatureTemplateResult()
     * @uses StartSignatureTemplateResponse::setTicket()
     * @uses StartSignatureTemplateResponse::setHandySignaturUrl()
     * @param int $startSignatureTemplateResult
     * @param string $ticket
     * @param string $handySignaturUrl
     */
    public function __construct($startSignatureTemplateResult = null, $ticket = null, $handySignaturUrl = null)
    {
        $this
            ->setStartSignatureTemplateResult($startSignatureTemplateResult)
            ->setTicket($ticket)
            ->setHandySignaturUrl($handySignaturUrl);
    }
    /**
     * Get StartSignatureTemplateResult value
     * @return int|null
     */
    public function getStartSignatureTemplateResult()
    {
        return $this->StartSignatureTemplateResult;
    }
    /**
     * Set StartSignatureTemplateResult value
     * @param int $startSignatureTemplateResult
     * @return \StructType\StartSignatureTemplateResponse
     */
    public function setStartSignatureTemplateResult($startSignatureTemplateResult = null)
    {
        // validation for constraint: int
        if (!is_null($startSignatureTemplateResult) && !(is_int($startSignatureTemplateResult) || ctype_digit($startSignatureTemplateResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startSignatureTemplateResult, true), gettype($startSignatureTemplateResult)), __LINE__);
        }
        $this->StartSignatureTemplateResult = $startSignatureTemplateResult;
        return $this;
    }
    /**
     * Get Ticket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicket()
    {
        return isset($this->Ticket) ? $this->Ticket : null;
    }
    /**
     * Set Ticket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticket
     * @return \StructType\StartSignatureTemplateResponse
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        if (is_null($ticket) || (is_array($ticket) && empty($ticket))) {
            unset($this->Ticket);
        } else {
            $this->Ticket = $ticket;
        }
        return $this;
    }
    /**
     * Get HandySignaturUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandySignaturUrl()
    {
        return isset($this->HandySignaturUrl) ? $this->HandySignaturUrl : null;
    }
    /**
     * Set HandySignaturUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handySignaturUrl
     * @return \StructType\StartSignatureTemplateResponse
     */
    public function setHandySignaturUrl($handySignaturUrl = null)
    {
        // validation for constraint: string
        if (!is_null($handySignaturUrl) && !is_string($handySignaturUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handySignaturUrl, true), gettype($handySignaturUrl)), __LINE__);
        }
        if (is_null($handySignaturUrl) || (is_array($handySignaturUrl) && empty($handySignaturUrl))) {
            unset($this->HandySignaturUrl);
        } else {
            $this->HandySignaturUrl = $handySignaturUrl;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartSignatureTemplateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
