<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartBatchSignatureResponse StructType
 * @subpackage Structs
 */
class StartBatchSignatureResponse extends AbstractStructBase
{
    /**
     * The StartBatchSignatureResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StartBatchSignatureResult;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ticket;
    /**
     * Constructor method for StartBatchSignatureResponse
     * @uses StartBatchSignatureResponse::setStartBatchSignatureResult()
     * @uses StartBatchSignatureResponse::setTicket()
     * @param int $startBatchSignatureResult
     * @param string $ticket
     */
    public function __construct($startBatchSignatureResult = null, $ticket = null)
    {
        $this
            ->setStartBatchSignatureResult($startBatchSignatureResult)
            ->setTicket($ticket);
    }
    /**
     * Get StartBatchSignatureResult value
     * @return int|null
     */
    public function getStartBatchSignatureResult()
    {
        return $this->StartBatchSignatureResult;
    }
    /**
     * Set StartBatchSignatureResult value
     * @param int $startBatchSignatureResult
     * @return \StructType\StartBatchSignatureResponse
     */
    public function setStartBatchSignatureResult($startBatchSignatureResult = null)
    {
        // validation for constraint: int
        if (!is_null($startBatchSignatureResult) && !(is_int($startBatchSignatureResult) || ctype_digit($startBatchSignatureResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startBatchSignatureResult, true), gettype($startBatchSignatureResult)), __LINE__);
        }
        $this->StartBatchSignatureResult = $startBatchSignatureResult;
        return $this;
    }
    /**
     * Get Ticket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicket()
    {
        return isset($this->Ticket) ? $this->Ticket : null;
    }
    /**
     * Set Ticket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticket
     * @return \StructType\StartBatchSignatureResponse
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        if (is_null($ticket) || (is_array($ticket) && empty($ticket))) {
            unset($this->Ticket);
        } else {
            $this->Ticket = $ticket;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartBatchSignatureResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
