<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartBatchSignature StructType
 * @subpackage Structs
 */
class StartBatchSignature extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $APIKey;
    /**
     * The RedirectURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RedirectURL;
    /**
     * The ErrorURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorURL;
    /**
     * Constructor method for StartBatchSignature
     * @uses StartBatchSignature::setAPIKey()
     * @uses StartBatchSignature::setRedirectURL()
     * @uses StartBatchSignature::setErrorURL()
     * @param string $aPIKey
     * @param string $redirectURL
     * @param string $errorURL
     */
    public function __construct($aPIKey = null, $redirectURL = null, $errorURL = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setRedirectURL($redirectURL)
            ->setErrorURL($errorURL);
    }
    /**
     * Get APIKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAPIKey()
    {
        return isset($this->APIKey) ? $this->APIKey : null;
    }
    /**
     * Set APIKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aPIKey
     * @return \StructType\StartBatchSignature
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIKey, true), gettype($aPIKey)), __LINE__);
        }
        if (is_null($aPIKey) || (is_array($aPIKey) && empty($aPIKey))) {
            unset($this->APIKey);
        } else {
            $this->APIKey = $aPIKey;
        }
        return $this;
    }
    /**
     * Get RedirectURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRedirectURL()
    {
        return isset($this->RedirectURL) ? $this->RedirectURL : null;
    }
    /**
     * Set RedirectURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $redirectURL
     * @return \StructType\StartBatchSignature
     */
    public function setRedirectURL($redirectURL = null)
    {
        // validation for constraint: string
        if (!is_null($redirectURL) && !is_string($redirectURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectURL, true), gettype($redirectURL)), __LINE__);
        }
        if (is_null($redirectURL) || (is_array($redirectURL) && empty($redirectURL))) {
            unset($this->RedirectURL);
        } else {
            $this->RedirectURL = $redirectURL;
        }
        return $this;
    }
    /**
     * Get ErrorURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorURL()
    {
        return isset($this->ErrorURL) ? $this->ErrorURL : null;
    }
    /**
     * Set ErrorURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorURL
     * @return \StructType\StartBatchSignature
     */
    public function setErrorURL($errorURL = null)
    {
        // validation for constraint: string
        if (!is_null($errorURL) && !is_string($errorURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorURL, true), gettype($errorURL)), __LINE__);
        }
        if (is_null($errorURL) || (is_array($errorURL) && empty($errorURL))) {
            unset($this->ErrorURL);
        } else {
            $this->ErrorURL = $errorURL;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartBatchSignature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
