<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListTemplateResponse StructType
 * @subpackage Structs
 */
class ListTemplateResponse extends AbstractStructBase
{
    /**
     * The ListTemplateResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ListTemplateResult;
    /**
     * The list
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $list;
    /**
     * Constructor method for ListTemplateResponse
     * @uses ListTemplateResponse::setListTemplateResult()
     * @uses ListTemplateResponse::setList()
     * @param int $listTemplateResult
     * @param string $list
     */
    public function __construct($listTemplateResult = null, $list = null)
    {
        $this
            ->setListTemplateResult($listTemplateResult)
            ->setList($list);
    }
    /**
     * Get ListTemplateResult value
     * @return int|null
     */
    public function getListTemplateResult()
    {
        return $this->ListTemplateResult;
    }
    /**
     * Set ListTemplateResult value
     * @param int $listTemplateResult
     * @return \StructType\ListTemplateResponse
     */
    public function setListTemplateResult($listTemplateResult = null)
    {
        // validation for constraint: int
        if (!is_null($listTemplateResult) && !(is_int($listTemplateResult) || ctype_digit($listTemplateResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listTemplateResult, true), gettype($listTemplateResult)), __LINE__);
        }
        $this->ListTemplateResult = $listTemplateResult;
        return $this;
    }
    /**
     * Get list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getList()
    {
        return isset($this->list) ? $this->list : null;
    }
    /**
     * Set list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $list
     * @return \StructType\ListTemplateResponse
     */
    public function setList($list = null)
    {
        // validation for constraint: string
        if (!is_null($list) && !is_string($list)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($list, true), gettype($list)), __LINE__);
        }
        if (is_null($list) || (is_array($list) && empty($list))) {
            unset($this->list);
        } else {
            $this->list = $list;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListTemplateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
