<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getWBPKResponse StructType
 * @subpackage Structs
 */
class GetWBPKResponse extends AbstractStructBase
{
    /**
     * The getWBPKResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $getWBPKResult;
    /**
     * The WBPK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WBPK;
    /**
     * Constructor method for getWBPKResponse
     * @uses GetWBPKResponse::setGetWBPKResult()
     * @uses GetWBPKResponse::setWBPK()
     * @param int $getWBPKResult
     * @param string $wBPK
     */
    public function __construct($getWBPKResult = null, $wBPK = null)
    {
        $this
            ->setGetWBPKResult($getWBPKResult)
            ->setWBPK($wBPK);
    }
    /**
     * Get getWBPKResult value
     * @return int|null
     */
    public function getGetWBPKResult()
    {
        return $this->getWBPKResult;
    }
    /**
     * Set getWBPKResult value
     * @param int $getWBPKResult
     * @return \StructType\GetWBPKResponse
     */
    public function setGetWBPKResult($getWBPKResult = null)
    {
        // validation for constraint: int
        if (!is_null($getWBPKResult) && !(is_int($getWBPKResult) || ctype_digit($getWBPKResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($getWBPKResult, true), gettype($getWBPKResult)), __LINE__);
        }
        $this->getWBPKResult = $getWBPKResult;
        return $this;
    }
    /**
     * Get WBPK value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWBPK()
    {
        return isset($this->WBPK) ? $this->WBPK : null;
    }
    /**
     * Set WBPK value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wBPK
     * @return \StructType\GetWBPKResponse
     */
    public function setWBPK($wBPK = null)
    {
        // validation for constraint: string
        if (!is_null($wBPK) && !is_string($wBPK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wBPK, true), gettype($wBPK)), __LINE__);
        }
        if (is_null($wBPK) || (is_array($wBPK) && empty($wBPK))) {
            unset($this->WBPK);
        } else {
            $this->WBPK = $wBPK;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetWBPKResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
