<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getWBPK StructType
 * @subpackage Structs
 */
class GetWBPK extends AbstractStructBase
{
    /**
     * The ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiKey;
    /**
     * The SessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionID;
    /**
     * Constructor method for getWBPK
     * @uses GetWBPK::setApiKey()
     * @uses GetWBPK::setSessionID()
     * @param string $apiKey
     * @param string $sessionID
     */
    public function __construct($apiKey = null, $sessionID = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setSessionID($sessionID);
    }
    /**
     * Get ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiKey()
    {
        return isset($this->ApiKey) ? $this->ApiKey : null;
    }
    /**
     * Set ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiKey
     * @return \StructType\GetWBPK
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        if (is_null($apiKey) || (is_array($apiKey) && empty($apiKey))) {
            unset($this->ApiKey);
        } else {
            $this->ApiKey = $apiKey;
        }
        return $this;
    }
    /**
     * Get SessionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionID()
    {
        return isset($this->SessionID) ? $this->SessionID : null;
    }
    /**
     * Set SessionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionID
     * @return \StructType\GetWBPK
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        if (is_null($sessionID) || (is_array($sessionID) && empty($sessionID))) {
            unset($this->SessionID);
        } else {
            $this->SessionID = $sessionID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetWBPK
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
