<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoP12SignatureTemplateResponse StructType
 * @subpackage Structs
 */
class DoP12SignatureTemplateResponse extends AbstractStructBase
{
    /**
     * The DoP12SignatureTemplateResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DoP12SignatureTemplateResult;
    /**
     * The SignedDocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SignedDocumentData;
    /**
     * Constructor method for DoP12SignatureTemplateResponse
     * @uses DoP12SignatureTemplateResponse::setDoP12SignatureTemplateResult()
     * @uses DoP12SignatureTemplateResponse::setSignedDocumentData()
     * @param int $doP12SignatureTemplateResult
     * @param string $signedDocumentData
     */
    public function __construct($doP12SignatureTemplateResult = null, $signedDocumentData = null)
    {
        $this
            ->setDoP12SignatureTemplateResult($doP12SignatureTemplateResult)
            ->setSignedDocumentData($signedDocumentData);
    }
    /**
     * Get DoP12SignatureTemplateResult value
     * @return int|null
     */
    public function getDoP12SignatureTemplateResult()
    {
        return $this->DoP12SignatureTemplateResult;
    }
    /**
     * Set DoP12SignatureTemplateResult value
     * @param int $doP12SignatureTemplateResult
     * @return \StructType\DoP12SignatureTemplateResponse
     */
    public function setDoP12SignatureTemplateResult($doP12SignatureTemplateResult = null)
    {
        // validation for constraint: int
        if (!is_null($doP12SignatureTemplateResult) && !(is_int($doP12SignatureTemplateResult) || ctype_digit($doP12SignatureTemplateResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doP12SignatureTemplateResult, true), gettype($doP12SignatureTemplateResult)), __LINE__);
        }
        $this->DoP12SignatureTemplateResult = $doP12SignatureTemplateResult;
        return $this;
    }
    /**
     * Get SignedDocumentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignedDocumentData()
    {
        return isset($this->SignedDocumentData) ? $this->SignedDocumentData : null;
    }
    /**
     * Set SignedDocumentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signedDocumentData
     * @return \StructType\DoP12SignatureTemplateResponse
     */
    public function setSignedDocumentData($signedDocumentData = null)
    {
        // validation for constraint: string
        if (!is_null($signedDocumentData) && !is_string($signedDocumentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signedDocumentData, true), gettype($signedDocumentData)), __LINE__);
        }
        if (is_null($signedDocumentData) || (is_array($signedDocumentData) && empty($signedDocumentData))) {
            unset($this->SignedDocumentData);
        } else {
            $this->SignedDocumentData = $signedDocumentData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoP12SignatureTemplateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
